/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.dfs.internal;

import com.contrastsecurity.thirdparty.dfs.RateLimiterConfig;
import com.contrastsecurity.thirdparty.dfs.internal.RateLimiterStats;
import java.time.Duration;

class BurstyRateLimiterStats
extends RateLimiterStats {
    final long periodPermits;
    private final long periodNanos;
    private long availablePermits;
    private long currentPeriod;

    BurstyRateLimiterStats(RateLimiterConfig<?> rateLimiterConfig, RateLimiterStats.Stopwatch stopwatch) {
        super(stopwatch);
        this.periodPermits = rateLimiterConfig.getMaxPermits();
        this.periodNanos = rateLimiterConfig.getPeriod().toNanos();
        this.availablePermits = this.periodPermits;
    }

    @Override
    public synchronized long acquirePermits(long l2, Duration duration) {
        long l3;
        long l4;
        long l5 = this.stopwatch.elapsedNanos();
        long l6 = l5 / this.periodNanos;
        if (this.currentPeriod < l6) {
            l4 = l6 - this.currentPeriod;
            l3 = l4 * this.periodPermits;
            this.currentPeriod = l6;
            this.availablePermits = this.availablePermits < 0L ? this.availablePermits + l3 : this.periodPermits;
        }
        l4 = 0L;
        if (l2 > this.availablePermits) {
            l3 = (this.currentPeriod + 1L) * this.periodNanos;
            long l7 = l3 - l5;
            long l8 = l2 - this.availablePermits;
            long l9 = l8 / this.periodPermits;
            long l10 = l8 % this.periodPermits;
            if (l10 == 0L) {
                --l9;
            }
            if (this.exceedsMaxWaitTime(l4 = l7 + l9 * this.periodNanos, duration)) {
                return -1L;
            }
        }
        this.availablePermits -= l2;
        return l4;
    }

    synchronized long getAvailablePermits() {
        return this.availablePermits;
    }

    synchronized long getCurrentPeriod() {
        return this.currentPeriod;
    }

    @Override
    synchronized void reset() {
        this.stopwatch.reset();
        this.availablePermits = this.periodPermits;
        this.currentPeriod = 0L;
    }
}

