/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.instrument;

import com.contrastsecurity.thirdparty.imm.common.lang.Nullable;
import com.contrastsecurity.thirdparty.imm.core.instrument.AbstractMeter;
import com.contrastsecurity.thirdparty.imm.core.instrument.Clock;
import com.contrastsecurity.thirdparty.imm.core.instrument.DistributionSummary;
import com.contrastsecurity.thirdparty.imm.core.instrument.Meter;
import com.contrastsecurity.thirdparty.imm.core.instrument.distribution.DistributionStatisticConfig;
import com.contrastsecurity.thirdparty.imm.core.instrument.distribution.Histogram;
import com.contrastsecurity.thirdparty.imm.core.instrument.distribution.HistogramSnapshot;
import com.contrastsecurity.thirdparty.imm.core.instrument.distribution.NoopHistogram;
import com.contrastsecurity.thirdparty.imm.core.instrument.distribution.TimeWindowFixedBoundaryHistogram;
import com.contrastsecurity.thirdparty.imm.core.instrument.distribution.TimeWindowPercentileHistogram;

public abstract class AbstractDistributionSummary
extends AbstractMeter
implements DistributionSummary {
    protected final Histogram histogram;
    private final double scale;

    protected AbstractDistributionSummary(Meter.Id id, Clock clock, DistributionStatisticConfig distributionStatisticConfig, double d2, boolean bl2) {
        this(id, d2, AbstractDistributionSummary.defaultHistogram(clock, distributionStatisticConfig, bl2));
    }

    protected AbstractDistributionSummary(Meter.Id id, double d2, @Nullable Histogram histogram) {
        super(id);
        this.scale = d2;
        this.histogram = histogram == null ? NoopHistogram.INSTANCE : histogram;
    }

    protected static Histogram defaultHistogram(Clock clock, DistributionStatisticConfig distributionStatisticConfig, boolean bl2) {
        if (distributionStatisticConfig.isPublishingPercentiles()) {
            return new TimeWindowPercentileHistogram(clock, distributionStatisticConfig, bl2);
        }
        if (distributionStatisticConfig.isPublishingHistogram()) {
            return new TimeWindowFixedBoundaryHistogram(clock, distributionStatisticConfig, bl2);
        }
        return NoopHistogram.INSTANCE;
    }

    @Override
    public final void record(double d2) {
        if (d2 >= 0.0) {
            double d3 = this.scale * d2;
            this.histogram.recordDouble(d3);
            this.recordNonNegative(d3);
        }
    }

    protected abstract void recordNonNegative(double var1);

    @Override
    public HistogramSnapshot takeSnapshot() {
        return this.histogram.takeSnapshot(this.count(), this.totalAmount(), this.max());
    }
}

