/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.instrument;

import com.contrastsecurity.thirdparty.imm.common.lang.Nullable;
import com.contrastsecurity.thirdparty.imm.core.instrument.Measurement;
import com.contrastsecurity.thirdparty.imm.core.instrument.Meter;
import com.contrastsecurity.thirdparty.imm.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.imm.core.instrument.Statistic;
import com.contrastsecurity.thirdparty.imm.core.instrument.Tag;
import com.contrastsecurity.thirdparty.imm.core.instrument.Tags;
import com.contrastsecurity.thirdparty.imm.core.instrument.distribution.CountAtBucket;
import com.contrastsecurity.thirdparty.imm.core.instrument.distribution.DistributionStatisticConfig;
import com.contrastsecurity.thirdparty.imm.core.instrument.distribution.HistogramSupport;
import com.contrastsecurity.thirdparty.imm.core.instrument.distribution.ValueAtPercentile;
import java.time.Duration;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

public interface DistributionSummary
extends Meter,
HistogramSupport {
    public static Builder builder(String string) {
        return new Builder(string);
    }

    public void record(double var1);

    public long count();

    public double totalAmount();

    default public double mean() {
        long l2 = this.count();
        return l2 == 0L ? 0.0 : this.totalAmount() / (double)l2;
    }

    public double max();

    @Deprecated
    default public double histogramCountAtValue(long l2) {
        for (CountAtBucket countAtBucket : this.takeSnapshot().histogramCounts()) {
            if ((long)countAtBucket.bucket(TimeUnit.NANOSECONDS) != l2) continue;
            return countAtBucket.count();
        }
        return Double.NaN;
    }

    @Deprecated
    default public double percentile(double d2) {
        for (ValueAtPercentile valueAtPercentile : this.takeSnapshot().percentileValues()) {
            if (valueAtPercentile.percentile() != d2) continue;
            return valueAtPercentile.value();
        }
        return Double.NaN;
    }

    @Override
    default public Iterable<Measurement> measure() {
        return Arrays.asList(new Measurement(() -> this.count(), Statistic.COUNT), new Measurement(this::totalAmount, Statistic.TOTAL));
    }

    public static class Builder {
        private final String name;
        private Tags tags = Tags.empty();
        private DistributionStatisticConfig.Builder distributionConfigBuilder = DistributionStatisticConfig.builder();
        @Nullable
        private String description;
        @Nullable
        private String baseUnit;
        private double scale = 1.0;

        private Builder(String string) {
            this.name = string;
        }

        public Builder tags(String ... stringArray) {
            return this.tags(Tags.of(stringArray));
        }

        public Builder tags(Iterable<Tag> iterable) {
            this.tags = this.tags.and(iterable);
            return this;
        }

        public Builder tag(String string, String string2) {
            this.tags = this.tags.and(string, string2);
            return this;
        }

        public Builder description(@Nullable String string) {
            this.description = string;
            return this;
        }

        public Builder baseUnit(@Nullable String string) {
            this.baseUnit = string;
            return this;
        }

        public Builder publishPercentiles(double ... dArray) {
            this.distributionConfigBuilder.percentiles(dArray);
            return this;
        }

        public Builder percentilePrecision(@Nullable Integer n2) {
            this.distributionConfigBuilder.percentilePrecision(n2);
            return this;
        }

        public Builder publishPercentileHistogram() {
            return this.publishPercentileHistogram(true);
        }

        public Builder publishPercentileHistogram(@Nullable Boolean bl2) {
            this.distributionConfigBuilder.percentilesHistogram(bl2);
            return this;
        }

        @Deprecated
        public Builder sla(long ... lArray) {
            return lArray == null ? this : this.serviceLevelObjectives(Arrays.stream(lArray).asDoubleStream().toArray());
        }

        @Deprecated
        public Builder sla(double ... dArray) {
            this.distributionConfigBuilder.serviceLevelObjectives(dArray);
            return this;
        }

        public Builder serviceLevelObjectives(double ... dArray) {
            this.distributionConfigBuilder.serviceLevelObjectives(dArray);
            return this;
        }

        @Deprecated
        public Builder minimumExpectedValue(@Nullable Long l2) {
            return l2 == null ? this : this.minimumExpectedValue((double)l2);
        }

        public Builder minimumExpectedValue(@Nullable Double d2) {
            this.distributionConfigBuilder.minimumExpectedValue(d2);
            return this;
        }

        @Deprecated
        public Builder maximumExpectedValue(@Nullable Long l2) {
            return l2 == null ? this : this.maximumExpectedValue((double)l2);
        }

        public Builder maximumExpectedValue(@Nullable Double d2) {
            this.distributionConfigBuilder.maximumExpectedValue(d2);
            return this;
        }

        public Builder distributionStatisticExpiry(@Nullable Duration duration) {
            this.distributionConfigBuilder.expiry(duration);
            return this;
        }

        public Builder distributionStatisticBufferLength(@Nullable Integer n2) {
            this.distributionConfigBuilder.bufferLength(n2);
            return this;
        }

        public Builder scale(double d2) {
            this.scale = d2;
            return this;
        }

        public DistributionSummary register(MeterRegistry meterRegistry) {
            return meterRegistry.summary(new Meter.Id(this.name, this.tags, this.baseUnit, this.description, Meter.Type.DISTRIBUTION_SUMMARY), this.distributionConfigBuilder.build(), this.scale);
        }
    }
}

