/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.instrument;

import com.contrastsecurity.thirdparty.imm.common.lang.Nullable;
import com.contrastsecurity.thirdparty.imm.core.instrument.Measurement;
import com.contrastsecurity.thirdparty.imm.core.instrument.Meter;
import com.contrastsecurity.thirdparty.imm.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.imm.core.instrument.Statistic;
import com.contrastsecurity.thirdparty.imm.core.instrument.Tag;
import com.contrastsecurity.thirdparty.imm.core.instrument.Tags;
import java.util.Collections;
import java.util.function.ToDoubleFunction;

public interface FunctionCounter
extends Meter {
    public static <T> Builder<T> builder(String string, @Nullable T t2, ToDoubleFunction<T> toDoubleFunction) {
        return new Builder(string, t2, toDoubleFunction);
    }

    public double count();

    @Override
    default public Iterable<Measurement> measure() {
        return Collections.singletonList(new Measurement(this::count, Statistic.COUNT));
    }

    public static class Builder<T> {
        private final String name;
        private final ToDoubleFunction<T> f;
        private Tags tags = Tags.empty();
        @Nullable
        private final T obj;
        @Nullable
        private String description;
        @Nullable
        private String baseUnit;

        private Builder(String string, @Nullable T t2, ToDoubleFunction<T> toDoubleFunction) {
            this.name = string;
            this.obj = t2;
            this.f = toDoubleFunction;
        }

        public Builder<T> tags(String ... stringArray) {
            return this.tags(Tags.of(stringArray));
        }

        public Builder<T> tags(Iterable<Tag> iterable) {
            this.tags = this.tags.and(iterable);
            return this;
        }

        public Builder<T> tag(String string, String string2) {
            this.tags = this.tags.and(string, string2);
            return this;
        }

        public Builder<T> description(@Nullable String string) {
            this.description = string;
            return this;
        }

        public Builder<T> baseUnit(@Nullable String string) {
            this.baseUnit = string;
            return this;
        }

        public FunctionCounter register(MeterRegistry meterRegistry) {
            return meterRegistry.more().counter(new Meter.Id(this.name, this.tags, this.baseUnit, this.description, Meter.Type.COUNTER), this.obj, this.f);
        }
    }
}

