/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.instrument;

import com.contrastsecurity.thirdparty.imm.common.lang.Nullable;
import com.contrastsecurity.thirdparty.imm.core.annotation.Incubating;
import com.contrastsecurity.thirdparty.imm.core.instrument.Counter;
import com.contrastsecurity.thirdparty.imm.core.instrument.DistributionSummary;
import com.contrastsecurity.thirdparty.imm.core.instrument.FunctionCounter;
import com.contrastsecurity.thirdparty.imm.core.instrument.FunctionTimer;
import com.contrastsecurity.thirdparty.imm.core.instrument.Gauge;
import com.contrastsecurity.thirdparty.imm.core.instrument.LongTaskTimer;
import com.contrastsecurity.thirdparty.imm.core.instrument.Measurement;
import com.contrastsecurity.thirdparty.imm.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.imm.core.instrument.Statistic;
import com.contrastsecurity.thirdparty.imm.core.instrument.Tag;
import com.contrastsecurity.thirdparty.imm.core.instrument.Tags;
import com.contrastsecurity.thirdparty.imm.core.instrument.TimeGauge;
import com.contrastsecurity.thirdparty.imm.core.instrument.Timer;
import com.contrastsecurity.thirdparty.imm.core.instrument.config.NamingConvention;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public interface Meter {
    public static Builder builder(String string, Type type, Iterable<Measurement> iterable) {
        return new Builder(string, type, iterable);
    }

    public Id getId();

    public Iterable<Measurement> measure();

    default public <T> T match(Function<Gauge, T> function, Function<Counter, T> function2, Function<Timer, T> function3, Function<DistributionSummary, T> function4, Function<LongTaskTimer, T> function5, Function<TimeGauge, T> function6, Function<FunctionCounter, T> function7, Function<FunctionTimer, T> function8, Function<Meter, T> function9) {
        if (this instanceof TimeGauge) {
            return function6.apply((TimeGauge)this);
        }
        if (this instanceof Gauge) {
            return function.apply((Gauge)this);
        }
        if (this instanceof Counter) {
            return function2.apply((Counter)this);
        }
        if (this instanceof Timer) {
            return function3.apply((Timer)this);
        }
        if (this instanceof DistributionSummary) {
            return function4.apply((DistributionSummary)this);
        }
        if (this instanceof LongTaskTimer) {
            return function5.apply((LongTaskTimer)this);
        }
        if (this instanceof FunctionCounter) {
            return function7.apply((FunctionCounter)this);
        }
        if (this instanceof FunctionTimer) {
            return function8.apply((FunctionTimer)this);
        }
        return function9.apply(this);
    }

    default public void use(Consumer<Gauge> consumer, Consumer<Counter> consumer2, Consumer<Timer> consumer3, Consumer<DistributionSummary> consumer4, Consumer<LongTaskTimer> consumer5, Consumer<TimeGauge> consumer6, Consumer<FunctionCounter> consumer7, Consumer<FunctionTimer> consumer8, Consumer<Meter> consumer9) {
        if (this instanceof TimeGauge) {
            consumer6.accept((TimeGauge)this);
        } else if (this instanceof Gauge) {
            consumer.accept((Gauge)this);
        } else if (this instanceof Counter) {
            consumer2.accept((Counter)this);
        } else if (this instanceof Timer) {
            consumer3.accept((Timer)this);
        } else if (this instanceof DistributionSummary) {
            consumer4.accept((DistributionSummary)this);
        } else if (this instanceof LongTaskTimer) {
            consumer5.accept((LongTaskTimer)this);
        } else if (this instanceof FunctionCounter) {
            consumer7.accept((FunctionCounter)this);
        } else if (this instanceof FunctionTimer) {
            consumer8.accept((FunctionTimer)this);
        } else {
            consumer9.accept(this);
        }
    }

    default public void close() {
    }

    public static class Builder {
        private final String name;
        private final Type type;
        private final Iterable<Measurement> measurements;
        private Tags tags = Tags.empty();
        @Nullable
        private String description;
        @Nullable
        private String baseUnit;

        private Builder(String string, Type type, Iterable<Measurement> iterable) {
            this.name = string;
            this.type = type;
            this.measurements = iterable;
        }

        public Builder tags(String ... stringArray) {
            return this.tags(Tags.of(stringArray));
        }

        public Builder tags(Iterable<Tag> iterable) {
            this.tags = this.tags.and(iterable);
            return this;
        }

        public Builder tag(String string, String string2) {
            this.tags = this.tags.and(string, string2);
            return this;
        }

        public Builder description(@Nullable String string) {
            this.description = string;
            return this;
        }

        public Builder baseUnit(@Nullable String string) {
            this.baseUnit = string;
            return this;
        }

        public Meter register(MeterRegistry meterRegistry) {
            return meterRegistry.register(new Id(this.name, this.tags, this.baseUnit, this.description, this.type), this.type, this.measurements);
        }
    }

    public static enum Type {
        COUNTER,
        GAUGE,
        LONG_TASK_TIMER,
        TIMER,
        DISTRIBUTION_SUMMARY,
        OTHER;

    }

    public static class Id {
        private final String name;
        private final Tags tags;
        private final Type type;
        @Nullable
        private final Id syntheticAssociation;
        @Nullable
        private final String description;
        @Nullable
        private final String baseUnit;

        @Incubating(since="1.1.0")
        Id(String string, Tags tags, @Nullable String string2, @Nullable String string3, Type type, @Nullable Id id) {
            this.name = string;
            this.tags = tags;
            this.baseUnit = string2;
            this.description = string3;
            this.type = type;
            this.syntheticAssociation = id;
        }

        public Id(String string, Tags tags, @Nullable String string2, @Nullable String string3, Type type) {
            this(string, tags, string2, string3, type, null);
        }

        public Id withName(String string) {
            return new Id(string, this.tags, this.baseUnit, this.description, this.type);
        }

        public Id withTag(Tag tag) {
            return this.withTags(Collections.singletonList(tag));
        }

        public Id withTags(Iterable<Tag> iterable) {
            return new Id(this.name, Tags.concat(this.getTags(), iterable), this.baseUnit, this.description, this.type);
        }

        public Id replaceTags(Iterable<Tag> iterable) {
            return new Id(this.name, Tags.of(iterable), this.baseUnit, this.description, this.type);
        }

        public Id withTag(Statistic statistic) {
            return this.withTag(Tag.of("statistic", statistic.getTagValueRepresentation()));
        }

        public Id withBaseUnit(@Nullable String string) {
            return new Id(this.name, this.tags, string, this.description, this.type);
        }

        public String getName() {
            return this.name;
        }

        public List<Tag> getTags() {
            ArrayList arrayList = new ArrayList();
            this.tags.forEach(arrayList::add);
            return Collections.unmodifiableList(arrayList);
        }

        public Iterable<Tag> getTagsAsIterable() {
            return this.tags;
        }

        @Nullable
        public String getTag(String string) {
            for (Tag tag : this.tags) {
                if (!tag.getKey().equals(string)) continue;
                return tag.getValue();
            }
            return null;
        }

        @Nullable
        public String getBaseUnit() {
            return this.baseUnit;
        }

        public String getConventionName(NamingConvention namingConvention) {
            return namingConvention.name(this.name, this.type, this.baseUnit);
        }

        public List<Tag> getConventionTags(NamingConvention namingConvention) {
            return StreamSupport.stream(this.tags.spliterator(), false).map(tag -> Tag.of(namingConvention.tagKey(tag.getKey()), namingConvention.tagValue(tag.getValue()))).collect(Collectors.toList());
        }

        @Nullable
        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return "MeterId{name='" + this.name + '\'' + ", tags=" + this.tags + '}';
        }

        public boolean equals(@Nullable Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Id id = (Id)object;
            return Objects.equals(this.name, id.name) && Objects.equals(this.tags, id.tags);
        }

        public int hashCode() {
            int n2 = this.name.hashCode();
            n2 = 31 * n2 + this.tags.hashCode();
            return n2;
        }

        public Type getType() {
            return this.type;
        }

        @Nullable
        @Incubating(since="1.1.0")
        public Id syntheticAssociation() {
            return this.syntheticAssociation;
        }
    }
}

