/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.instrument.binder.cache;

import com.contrastsecurity.thirdparty.imm.common.lang.NonNullApi;
import com.contrastsecurity.thirdparty.imm.common.lang.NonNullFields;
import com.contrastsecurity.thirdparty.imm.common.lang.Nullable;
import com.contrastsecurity.thirdparty.imm.core.instrument.FunctionCounter;
import com.contrastsecurity.thirdparty.imm.core.instrument.Gauge;
import com.contrastsecurity.thirdparty.imm.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.imm.core.instrument.Tag;
import com.contrastsecurity.thirdparty.imm.core.instrument.Tags;
import com.contrastsecurity.thirdparty.imm.core.instrument.binder.cache.CacheMeterBinder;
import java.util.function.Function;
import java.util.function.ToLongFunction;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.statistics.StatisticsGateway;

@NonNullApi
@NonNullFields
public class EhCache2Metrics
extends CacheMeterBinder<Ehcache> {
    private static final String DESCRIPTION_CACHE_PUTS_ADDED = "Cache puts (added or updated)";
    private static final String DESCRIPTION_CACHE_MISSES = "The number of times cache lookup methods have not returned a value, due to expiry or because the key was not found";
    private static final String DESCRIPTION_CACHE_XA_COMMITS = "The number of transaction commits";
    private static final String DESCRIPTION_CACHE_XA_ROLLBACKS = "The number of transaction rollbacks";
    private static final String DESCRIPTION_CACHE_XA_RECOVERIES = "The number of transaction recoveries";

    public EhCache2Metrics(Ehcache ehcache, Iterable<Tag> iterable) {
        super(ehcache, ehcache.getName(), iterable);
    }

    public static Ehcache monitor(MeterRegistry meterRegistry, Ehcache ehcache, String ... stringArray) {
        return EhCache2Metrics.monitor(meterRegistry, ehcache, Tags.of(stringArray));
    }

    public static Ehcache monitor(MeterRegistry meterRegistry, Ehcache ehcache, Iterable<Tag> iterable) {
        new EhCache2Metrics(ehcache, iterable).bindTo(meterRegistry);
        return ehcache;
    }

    @Override
    protected Long size() {
        return this.getOrDefault(StatisticsGateway::getSize, null);
    }

    @Override
    protected long hitCount() {
        return this.getOrDefault(StatisticsGateway::cacheHitCount, 0L);
    }

    @Override
    protected Long missCount() {
        return this.getOrDefault(StatisticsGateway::cacheMissCount, null);
    }

    @Override
    protected Long evictionCount() {
        return this.getOrDefault(StatisticsGateway::cacheEvictedCount, null);
    }

    @Override
    protected long putCount() {
        return this.getOrDefault(StatisticsGateway::cachePutCount, 0L);
    }

    @Override
    protected void bindImplementationSpecificMetrics(MeterRegistry meterRegistry) {
        StatisticsGateway statisticsGateway = this.getStats();
        Gauge.builder("cache.remoteSize", statisticsGateway, StatisticsGateway::getRemoteSize).tags(this.getTagsWithCacheName()).description("The number of entries held remotely in this cache").register(meterRegistry);
        FunctionCounter.builder("cache.removals", statisticsGateway, StatisticsGateway::cacheRemoveCount).tags(this.getTagsWithCacheName()).description("Cache removals").register(meterRegistry);
        FunctionCounter.builder("cache.puts.added", statisticsGateway, StatisticsGateway::cachePutAddedCount).tags(this.getTagsWithCacheName()).tags("result", "added").description(DESCRIPTION_CACHE_PUTS_ADDED).register(meterRegistry);
        FunctionCounter.builder("cache.puts.added", statisticsGateway, StatisticsGateway::cachePutUpdatedCount).tags(this.getTagsWithCacheName()).tags("result", "updated").description(DESCRIPTION_CACHE_PUTS_ADDED).register(meterRegistry);
        this.missMetrics(meterRegistry);
        this.commitTransactionMetrics(meterRegistry);
        this.rollbackTransactionMetrics(meterRegistry);
        this.recoveryTransactionMetrics(meterRegistry);
        Gauge.builder("cache.local.offheap.size", statisticsGateway, StatisticsGateway::getLocalOffHeapSizeInBytes).tags(this.getTagsWithCacheName()).description("Local off-heap size").baseUnit("bytes").register(meterRegistry);
        Gauge.builder("cache.local.heap.size", statisticsGateway, StatisticsGateway::getLocalHeapSizeInBytes).tags(this.getTagsWithCacheName()).description("Local heap size").baseUnit("bytes").register(meterRegistry);
        Gauge.builder("cache.local.disk.size", statisticsGateway, StatisticsGateway::getLocalDiskSizeInBytes).tags(this.getTagsWithCacheName()).description("Local disk size").baseUnit("bytes").register(meterRegistry);
    }

    @Nullable
    private StatisticsGateway getStats() {
        Ehcache ehcache = (Ehcache)this.getCache();
        return ehcache != null ? ehcache.getStatistics() : null;
    }

    private void missMetrics(MeterRegistry meterRegistry) {
        StatisticsGateway statisticsGateway = this.getStats();
        FunctionCounter.builder("cache.misses", statisticsGateway, StatisticsGateway::cacheMissExpiredCount).tags(this.getTagsWithCacheName()).tags("reason", "expired").description(DESCRIPTION_CACHE_MISSES).register(meterRegistry);
        FunctionCounter.builder("cache.misses", statisticsGateway, StatisticsGateway::cacheMissNotFoundCount).tags(this.getTagsWithCacheName()).tags("reason", "notFound").description(DESCRIPTION_CACHE_MISSES).register(meterRegistry);
    }

    private void commitTransactionMetrics(MeterRegistry meterRegistry) {
        StatisticsGateway statisticsGateway = this.getStats();
        FunctionCounter.builder("cache.xa.commits", statisticsGateway, StatisticsGateway::xaCommitReadOnlyCount).tags(this.getTagsWithCacheName()).tags("result", "readOnly").description(DESCRIPTION_CACHE_XA_COMMITS).register(meterRegistry);
        FunctionCounter.builder("cache.xa.commits", statisticsGateway, StatisticsGateway::xaCommitExceptionCount).tags(this.getTagsWithCacheName()).tags("result", "exception").description(DESCRIPTION_CACHE_XA_COMMITS).register(meterRegistry);
        FunctionCounter.builder("cache.xa.commits", statisticsGateway, StatisticsGateway::xaCommitCommittedCount).tags(this.getTagsWithCacheName()).tags("result", "committed").description(DESCRIPTION_CACHE_XA_COMMITS).register(meterRegistry);
    }

    private void rollbackTransactionMetrics(MeterRegistry meterRegistry) {
        StatisticsGateway statisticsGateway = this.getStats();
        FunctionCounter.builder("cache.xa.rollbacks", statisticsGateway, StatisticsGateway::xaRollbackExceptionCount).tags(this.getTagsWithCacheName()).tags("result", "exception").description(DESCRIPTION_CACHE_XA_ROLLBACKS).register(meterRegistry);
        FunctionCounter.builder("cache.xa.rollbacks", statisticsGateway, StatisticsGateway::xaRollbackSuccessCount).tags(this.getTagsWithCacheName()).tags("result", "success").description(DESCRIPTION_CACHE_XA_ROLLBACKS).register(meterRegistry);
    }

    private void recoveryTransactionMetrics(MeterRegistry meterRegistry) {
        StatisticsGateway statisticsGateway = this.getStats();
        FunctionCounter.builder("cache.xa.recoveries", statisticsGateway, StatisticsGateway::xaRecoveryNothingCount).tags(this.getTagsWithCacheName()).tags("result", "nothing").description(DESCRIPTION_CACHE_XA_RECOVERIES).register(meterRegistry);
        FunctionCounter.builder("cache.xa.recoveries", statisticsGateway, StatisticsGateway::xaRecoveryRecoveredCount).tags(this.getTagsWithCacheName()).tags("result", "success").description(DESCRIPTION_CACHE_XA_RECOVERIES).register(meterRegistry);
    }

    @Nullable
    private Long getOrDefault(Function<StatisticsGateway, Long> function, @Nullable Long l2) {
        StatisticsGateway statisticsGateway = this.getStats();
        if (statisticsGateway != null) {
            return function.apply(statisticsGateway);
        }
        return l2;
    }

    private long getOrDefault(ToLongFunction<StatisticsGateway> toLongFunction, long l2) {
        StatisticsGateway statisticsGateway = this.getStats();
        if (statisticsGateway != null) {
            return toLongFunction.applyAsLong(statisticsGateway);
        }
        return l2;
    }
}

