/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.instrument.binder.db;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.imm.common.lang.NonNullApi;
import com.contrastsecurity.thirdparty.imm.common.lang.NonNullFields;
import com.contrastsecurity.thirdparty.imm.core.instrument.FunctionCounter;
import com.contrastsecurity.thirdparty.imm.core.instrument.Gauge;
import com.contrastsecurity.thirdparty.imm.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.imm.core.instrument.Tag;
import com.contrastsecurity.thirdparty.imm.core.instrument.Tags;
import com.contrastsecurity.thirdparty.imm.core.instrument.binder.MeterBinder;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.DoubleSupplier;
import javax.sql.DataSource;

@NonNullApi
@NonNullFields
public class PostgreSQLDatabaseMetrics
implements MeterBinder {
    private static final String SELECT = "SELECT ";
    private static final String QUERY_DEAD_TUPLE_COUNT = PostgreSQLDatabaseMetrics.getUserTableQuery("SUM(n_dead_tup)");
    private static final String QUERY_TIMED_CHECKPOINTS_COUNT = PostgreSQLDatabaseMetrics.getBgWriterQuery("checkpoints_timed");
    private static final String QUERY_REQUESTED_CHECKPOINTS_COUNT = PostgreSQLDatabaseMetrics.getBgWriterQuery("checkpoints_req");
    private static final String QUERY_BUFFERS_CLEAN = PostgreSQLDatabaseMetrics.getBgWriterQuery("buffers_clean");
    private static final String QUERY_BUFFERS_BACKEND = PostgreSQLDatabaseMetrics.getBgWriterQuery("buffers_backend");
    private static final String QUERY_BUFFERS_CHECKPOINT = PostgreSQLDatabaseMetrics.getBgWriterQuery("buffers_checkpoint");
    private final String database;
    private final DataSource postgresDataSource;
    private final Iterable<Tag> tags;
    private final Map<String, Double> beforeResetValuesCacheMap;
    private final Map<String, Double> previousValueCacheMap;
    private final String queryConnectionCount;
    private final String queryReadCount;
    private final String queryInsertCount;
    private final String queryTempBytes;
    private final String queryUpdateCount;
    private final String queryDeleteCount;
    private final String queryBlockHits;
    private final String queryBlockReads;
    private final String queryTransactionCount;

    public PostgreSQLDatabaseMetrics(DataSource dataSource, String string) {
        this(dataSource, string, Tags.empty());
    }

    public PostgreSQLDatabaseMetrics(DataSource dataSource, String string, Iterable<Tag> iterable) {
        this.postgresDataSource = dataSource;
        this.database = string;
        this.tags = Tags.of(iterable).and(PostgreSQLDatabaseMetrics.createDbTag(string));
        this.beforeResetValuesCacheMap = new ConcurrentHashMap<String, Double>();
        this.previousValueCacheMap = new ConcurrentHashMap<String, Double>();
        this.queryConnectionCount = PostgreSQLDatabaseMetrics.getDBStatQuery(string, "numbackends");
        this.queryReadCount = PostgreSQLDatabaseMetrics.getDBStatQuery(string, "tup_fetched");
        this.queryInsertCount = PostgreSQLDatabaseMetrics.getDBStatQuery(string, "tup_inserted");
        this.queryTempBytes = PostgreSQLDatabaseMetrics.getDBStatQuery(string, "temp_bytes");
        this.queryUpdateCount = PostgreSQLDatabaseMetrics.getDBStatQuery(string, "tup_updated");
        this.queryDeleteCount = PostgreSQLDatabaseMetrics.getDBStatQuery(string, "tup_deleted");
        this.queryBlockHits = PostgreSQLDatabaseMetrics.getDBStatQuery(string, "blks_hit");
        this.queryBlockReads = PostgreSQLDatabaseMetrics.getDBStatQuery(string, "blks_read");
        this.queryTransactionCount = PostgreSQLDatabaseMetrics.getDBStatQuery(string, "xact_commit + xact_rollback");
    }

    private static Tag createDbTag(String string) {
        return Tag.of("database", string);
    }

    @Override
    public void bindTo(MeterRegistry meterRegistry) {
        Gauge.builder(Names.SIZE, this.postgresDataSource, dataSource -> this.getDatabaseSize().longValue()).tags(this.tags).description("The database size").register(meterRegistry);
        Gauge.builder(Names.CONNECTIONS, this.postgresDataSource, dataSource -> this.getConnectionCount().longValue()).tags(this.tags).description("Number of active connections to the given db").register(meterRegistry);
        FunctionCounter.builder(Names.BLOCKS_HITS, this.postgresDataSource, dataSource -> this.resettableFunctionalCounter(Names.BLOCKS_HITS, this::getBlockHits)).tags(this.tags).description("Number of times disk blocks were found already in the buffer cache, so that a read was not necessary").register(meterRegistry);
        FunctionCounter.builder(Names.BLOCKS_READS, this.postgresDataSource, dataSource -> this.resettableFunctionalCounter(Names.BLOCKS_READS, this::getBlockReads)).tags(this.tags).description("Number of disk blocks read in this database").register(meterRegistry);
        FunctionCounter.builder(Names.TRANSACTIONS, this.postgresDataSource, dataSource -> this.resettableFunctionalCounter(Names.TRANSACTIONS, this::getTransactionCount)).tags(this.tags).description("Total number of transactions executed (commits + rollbacks)").register(meterRegistry);
        Gauge.builder(Names.LOCKS, this.postgresDataSource, dataSource -> this.getLockCount().longValue()).tags(this.tags).description("Number of locks on the given db").register(meterRegistry);
        FunctionCounter.builder(Names.TEMP_WRITES, this.postgresDataSource, dataSource -> this.resettableFunctionalCounter(Names.TEMP_WRITES, this::getTempBytes)).tags(this.tags).description("The total amount of temporary writes to disk to execute queries").baseUnit("bytes").register(meterRegistry);
        this.registerRowCountMetrics(meterRegistry);
        this.registerCheckpointMetrics(meterRegistry);
    }

    private void registerRowCountMetrics(MeterRegistry meterRegistry) {
        FunctionCounter.builder(Names.ROWS_FETCHED, this.postgresDataSource, dataSource -> this.resettableFunctionalCounter(Names.ROWS_FETCHED, this::getReadCount)).tags(this.tags).description("Number of rows fetched from the db").register(meterRegistry);
        FunctionCounter.builder(Names.ROWS_INSERTED, this.postgresDataSource, dataSource -> this.resettableFunctionalCounter(Names.ROWS_INSERTED, this::getInsertCount)).tags(this.tags).description("Number of rows inserted from the db").register(meterRegistry);
        FunctionCounter.builder(Names.ROWS_UPDATED, this.postgresDataSource, dataSource -> this.resettableFunctionalCounter(Names.ROWS_UPDATED, this::getUpdateCount)).tags(this.tags).description("Number of rows updated from the db").register(meterRegistry);
        FunctionCounter.builder(Names.ROWS_DELETED, this.postgresDataSource, dataSource -> this.resettableFunctionalCounter(Names.ROWS_DELETED, this::getDeleteCount)).tags(this.tags).description("Number of rows deleted from the db").register(meterRegistry);
        Gauge.builder(Names.ROWS_DEAD, this.postgresDataSource, dataSource -> this.getDeadTupleCount().longValue()).tags(this.tags).description("Total number of dead rows in the current database").register(meterRegistry);
    }

    private void registerCheckpointMetrics(MeterRegistry meterRegistry) {
        FunctionCounter.builder(Names.CHECKPOINTS_TIMED, this.postgresDataSource, dataSource -> this.resettableFunctionalCounter(Names.CHECKPOINTS_TIMED, this::getTimedCheckpointsCount)).tags(this.tags).description("Number of checkpoints timed").register(meterRegistry);
        FunctionCounter.builder(Names.CHECKPOINTS_REQUESTED, this.postgresDataSource, dataSource -> this.resettableFunctionalCounter(Names.CHECKPOINTS_REQUESTED, this::getRequestedCheckpointsCount)).tags(this.tags).description("Number of checkpoints requested").register(meterRegistry);
        FunctionCounter.builder(Names.BUFFERS_CHECKPOINT, this.postgresDataSource, dataSource -> this.resettableFunctionalCounter(Names.BUFFERS_CHECKPOINT, this::getBuffersCheckpoint)).tags(this.tags).description("Number of buffers written during checkpoints").register(meterRegistry);
        FunctionCounter.builder(Names.BUFFERS_CLEAN, this.postgresDataSource, dataSource -> this.resettableFunctionalCounter(Names.BUFFERS_CLEAN, this::getBuffersClean)).tags(this.tags).description("Number of buffers written by the background writer").register(meterRegistry);
        FunctionCounter.builder(Names.BUFFERS_BACKEND, this.postgresDataSource, dataSource -> this.resettableFunctionalCounter(Names.BUFFERS_BACKEND, this::getBuffersBackend)).tags(this.tags).description("Number of buffers written directly by a backend").register(meterRegistry);
    }

    private Long getDatabaseSize() {
        return this.runQuery("SELECT pg_database_size('" + this.database + "')");
    }

    private Long getLockCount() {
        return this.runQuery("SELECT count(*) FROM pg_locks l JOIN pg_database d ON l.DATABASE=d.oid WHERE d.datname='" + this.database + "'");
    }

    private Long getConnectionCount() {
        return this.runQuery(this.queryConnectionCount);
    }

    private Long getReadCount() {
        return this.runQuery(this.queryReadCount);
    }

    private Long getInsertCount() {
        return this.runQuery(this.queryInsertCount);
    }

    private Long getTempBytes() {
        return this.runQuery(this.queryTempBytes);
    }

    private Long getUpdateCount() {
        return this.runQuery(this.queryUpdateCount);
    }

    private Long getDeleteCount() {
        return this.runQuery(this.queryDeleteCount);
    }

    private Long getBlockHits() {
        return this.runQuery(this.queryBlockHits);
    }

    private Long getBlockReads() {
        return this.runQuery(this.queryBlockReads);
    }

    private Long getTransactionCount() {
        return this.runQuery(this.queryTransactionCount);
    }

    private Long getDeadTupleCount() {
        return this.runQuery(QUERY_DEAD_TUPLE_COUNT);
    }

    private Long getTimedCheckpointsCount() {
        return this.runQuery(QUERY_TIMED_CHECKPOINTS_COUNT);
    }

    private Long getRequestedCheckpointsCount() {
        return this.runQuery(QUERY_REQUESTED_CHECKPOINTS_COUNT);
    }

    private Long getBuffersClean() {
        return this.runQuery(QUERY_BUFFERS_CLEAN);
    }

    private Long getBuffersBackend() {
        return this.runQuery(QUERY_BUFFERS_BACKEND);
    }

    private Long getBuffersCheckpoint() {
        return this.runQuery(QUERY_BUFFERS_CHECKPOINT);
    }

    Double resettableFunctionalCounter(String string, DoubleSupplier doubleSupplier) {
        Double d2 = doubleSupplier.getAsDouble();
        Double d3 = this.previousValueCacheMap.getOrDefault(string, 0.0);
        Double d4 = this.beforeResetValuesCacheMap.getOrDefault(string, 0.0);
        Double d5 = d2 + d4;
        if (d5 < d3) {
            this.beforeResetValuesCacheMap.put(string, d3);
            d5 = d3 + d2;
        }
        this.previousValueCacheMap.put(string, d5);
        return d5;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Long runQuery(String string) {
        try {
            Object object;
            Object object2;
            Connection connection;
            block18: {
                Long l2;
                connection = this.postgresDataSource.getConnection();
                try {
                    block20: {
                        object2 = connection.createStatement();
                        try {
                            block19: {
                                object = object2.executeQuery(string);
                                try {
                                    if (!object.next()) break block18;
                                    l2 = object.getLong(1);
                                    if (object == null) break block19;
                                }
                                catch (Throwable throwable) {
                                    Throwables.throwIfCritical(throwable);
                                    Throwable throwable2 = throwable;
                                    if (object == null) throw throwable2;
                                    try {
                                        object.close();
                                        throw throwable2;
                                    }
                                    catch (Throwable throwable3) {
                                        Throwables.throwIfCritical(throwable3);
                                        Throwable throwable4 = throwable3;
                                        throwable2.addSuppressed(throwable4);
                                    }
                                    throw throwable2;
                                }
                                object.close();
                            }
                            if (object2 == null) break block20;
                        }
                        catch (Throwable throwable) {
                            Throwables.throwIfCritical(throwable);
                            object = throwable;
                            if (object2 == null) throw object;
                            try {
                                object2.close();
                                throw object;
                            }
                            catch (Throwable throwable5) {
                                Throwables.throwIfCritical(throwable5);
                                Throwable throwable6 = throwable5;
                                ((Throwable)object).addSuppressed(throwable6);
                            }
                            throw object;
                        }
                        object2.close();
                    }
                    if (connection == null) return l2;
                }
                catch (Throwable throwable) {
                    Throwables.throwIfCritical(throwable);
                    object2 = throwable;
                    if (connection == null) throw object2;
                    try {
                        connection.close();
                        throw object2;
                    }
                    catch (Throwable throwable7) {
                        Throwables.throwIfCritical(throwable7);
                        object = throwable7;
                        ((Throwable)object2).addSuppressed((Throwable)object);
                    }
                    throw object2;
                }
                connection.close();
                return l2;
            }
            if (object != null) {
                object.close();
            }
            if (object2 != null) {
                object2.close();
            }
            if (connection == null) return 0L;
            connection.close();
            return 0L;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return 0L;
    }

    private static String getDBStatQuery(String string, String string2) {
        return SELECT + string2 + " FROM pg_stat_database WHERE datname = '" + string + "'";
    }

    private static String getUserTableQuery(String string) {
        return SELECT + string + " FROM pg_stat_user_tables";
    }

    private static String getBgWriterQuery(String string) {
        return SELECT + string + " FROM pg_stat_bgwriter";
    }

    static final class Names {
        static final String SIZE = Names.of("size");
        static final String CONNECTIONS = Names.of("connections");
        static final String BLOCKS_HITS = Names.of("blocks.hits");
        static final String BLOCKS_READS = Names.of("blocks.reads");
        static final String TRANSACTIONS = Names.of("transactions");
        static final String LOCKS = Names.of("locks");
        static final String TEMP_WRITES = Names.of("temp.writes");
        static final String ROWS_FETCHED = Names.of("rows.fetched");
        static final String ROWS_INSERTED = Names.of("rows.inserted");
        static final String ROWS_UPDATED = Names.of("rows.updated");
        static final String ROWS_DELETED = Names.of("rows.deleted");
        static final String ROWS_DEAD = Names.of("rows.dead");
        static final String CHECKPOINTS_TIMED = Names.of("checkpoints.timed");
        static final String CHECKPOINTS_REQUESTED = Names.of("checkpoints.requested");
        static final String BUFFERS_CHECKPOINT = Names.of("buffers.checkpoint");
        static final String BUFFERS_CLEAN = Names.of("buffers.clean");
        static final String BUFFERS_BACKEND = Names.of("buffers.backend");

        private static String of(String string) {
            return "postgres." + string;
        }

        private Names() {
        }
    }
}

