/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.instrument.binder.grpc;

import com.contrastsecurity.thirdparty.imm.core.instrument.Counter;
import com.contrastsecurity.thirdparty.imm.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.imm.core.instrument.Timer;
import com.contrastsecurity.thirdparty.imm.core.instrument.binder.grpc.AbstractMetricCollectingInterceptor;
import com.contrastsecurity.thirdparty.imm.core.instrument.binder.grpc.MetricCollectingClientCall;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;

public class MetricCollectingClientInterceptor
extends AbstractMetricCollectingInterceptor
implements ClientInterceptor {
    private static final String METRIC_NAME_CLIENT_REQUESTS_SENT = "grpc.client.requests.sent";
    private static final String METRIC_NAME_CLIENT_RESPONSES_RECEIVED = "grpc.client.responses.received";
    private static final String METRIC_NAME_CLIENT_PROCESSING_DURATION = "grpc.client.processing.duration";

    public MetricCollectingClientInterceptor(MeterRegistry meterRegistry) {
        super(meterRegistry);
    }

    public MetricCollectingClientInterceptor(MeterRegistry meterRegistry, UnaryOperator<Counter.Builder> unaryOperator, UnaryOperator<Timer.Builder> unaryOperator2, Status.Code ... codeArray) {
        super(meterRegistry, unaryOperator, unaryOperator2, codeArray);
    }

    @Override
    protected Counter newRequestCounterFor(MethodDescriptor<?, ?> methodDescriptor) {
        return ((Counter.Builder)this.counterCustomizer.apply(MetricCollectingClientInterceptor.prepareCounterFor(methodDescriptor, METRIC_NAME_CLIENT_REQUESTS_SENT, "The total number of requests sent"))).register(this.registry);
    }

    @Override
    protected Counter newResponseCounterFor(MethodDescriptor<?, ?> methodDescriptor) {
        return ((Counter.Builder)this.counterCustomizer.apply(MetricCollectingClientInterceptor.prepareCounterFor(methodDescriptor, METRIC_NAME_CLIENT_RESPONSES_RECEIVED, "The total number of responses received"))).register(this.registry);
    }

    @Override
    protected Function<Status.Code, Timer> newTimerFunction(MethodDescriptor<?, ?> methodDescriptor) {
        return this.asTimerFunction(() -> (Timer.Builder)this.timerCustomizer.apply(MetricCollectingClientInterceptor.prepareTimerFor(methodDescriptor, METRIC_NAME_CLIENT_PROCESSING_DURATION, "The total time taken for the client to complete the call, including network delay")));
    }

    public <Q, A> ClientCall<Q, A> interceptCall(MethodDescriptor<Q, A> methodDescriptor, CallOptions callOptions, Channel channel) {
        AbstractMetricCollectingInterceptor.MetricSet metricSet = this.metricsFor(methodDescriptor);
        Consumer<Status.Code> consumer = metricSet.newProcessingDurationTiming(this.registry);
        return new MetricCollectingClientCall(channel.newCall(methodDescriptor, callOptions), metricSet.getRequestCounter(), metricSet.getResponseCounter(), consumer);
    }
}

