/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.instrument.binder.grpc;

import com.contrastsecurity.thirdparty.imm.core.instrument.Counter;
import com.contrastsecurity.thirdparty.imm.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.imm.core.instrument.Timer;
import com.contrastsecurity.thirdparty.imm.core.instrument.binder.grpc.AbstractMetricCollectingInterceptor;
import com.contrastsecurity.thirdparty.imm.core.instrument.binder.grpc.MetricCollectingServerCall;
import com.contrastsecurity.thirdparty.imm.core.instrument.binder.grpc.MetricCollectingServerCallListener;
import io.grpc.BindableService;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.Status;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;

public class MetricCollectingServerInterceptor
extends AbstractMetricCollectingInterceptor
implements ServerInterceptor {
    private static final String METRIC_NAME_SERVER_REQUESTS_RECEIVED = "grpc.server.requests.received";
    private static final String METRIC_NAME_SERVER_RESPONSES_SENT = "grpc.server.responses.sent";
    private static final String METRIC_NAME_SERVER_PROCESSING_DURATION = "grpc.server.processing.duration";

    public MetricCollectingServerInterceptor(MeterRegistry meterRegistry) {
        super(meterRegistry);
    }

    public MetricCollectingServerInterceptor(MeterRegistry meterRegistry, UnaryOperator<Counter.Builder> unaryOperator, UnaryOperator<Timer.Builder> unaryOperator2, Status.Code ... codeArray) {
        super(meterRegistry, unaryOperator, unaryOperator2, codeArray);
    }

    public void preregisterService(BindableService bindableService) {
        this.preregisterService(bindableService.bindService());
    }

    public void preregisterService(ServerServiceDefinition serverServiceDefinition) {
        this.preregisterService(serverServiceDefinition.getServiceDescriptor());
    }

    @Override
    protected Counter newRequestCounterFor(MethodDescriptor<?, ?> methodDescriptor) {
        return ((Counter.Builder)this.counterCustomizer.apply(MetricCollectingServerInterceptor.prepareCounterFor(methodDescriptor, METRIC_NAME_SERVER_REQUESTS_RECEIVED, "The total number of requests received"))).register(this.registry);
    }

    @Override
    protected Counter newResponseCounterFor(MethodDescriptor<?, ?> methodDescriptor) {
        return ((Counter.Builder)this.counterCustomizer.apply(MetricCollectingServerInterceptor.prepareCounterFor(methodDescriptor, METRIC_NAME_SERVER_RESPONSES_SENT, "The total number of responses sent"))).register(this.registry);
    }

    @Override
    protected Function<Status.Code, Timer> newTimerFunction(MethodDescriptor<?, ?> methodDescriptor) {
        return this.asTimerFunction(() -> (Timer.Builder)this.timerCustomizer.apply(MetricCollectingServerInterceptor.prepareTimerFor(methodDescriptor, METRIC_NAME_SERVER_PROCESSING_DURATION, "The total time taken for the server to complete the call")));
    }

    public <Q, A> ServerCall.Listener<Q> interceptCall(ServerCall<Q, A> serverCall, Metadata metadata, ServerCallHandler<Q, A> serverCallHandler) {
        AbstractMetricCollectingInterceptor.MetricSet metricSet = this.metricsFor(serverCall.getMethodDescriptor());
        Consumer<Status.Code> consumer = metricSet.newProcessingDurationTiming(this.registry);
        MetricCollectingServerCall<Q, A> metricCollectingServerCall = new MetricCollectingServerCall<Q, A>(serverCall, metricSet.getResponseCounter());
        return new MetricCollectingServerCallListener(serverCallHandler.startCall(metricCollectingServerCall, metadata), metricSet.getRequestCounter(), metricCollectingServerCall::getResponseCode, consumer);
    }
}

