/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.instrument.binder.jersey.server;

import com.contrastsecurity.thirdparty.imm.common.util.StringUtils;
import com.contrastsecurity.thirdparty.imm.core.instrument.Tag;
import com.contrastsecurity.thirdparty.imm.core.instrument.binder.http.Outcome;
import java.util.List;
import java.util.regex.Pattern;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.ExtendedUriInfo;
import org.glassfish.jersey.server.monitoring.RequestEvent;
import org.glassfish.jersey.uri.UriTemplate;

public final class JerseyTags {
    private static final Tag URI_NOT_FOUND = Tag.of("uri", "NOT_FOUND");
    private static final Tag URI_REDIRECTION = Tag.of("uri", "REDIRECTION");
    private static final Tag URI_ROOT = Tag.of("uri", "root");
    private static final Tag EXCEPTION_NONE = Tag.of("exception", "None");
    private static final Tag STATUS_SERVER_ERROR = Tag.of("status", "500");
    private static final Tag METHOD_UNKNOWN = Tag.of("method", "UNKNOWN");
    static final Pattern TRAILING_SLASH_PATTERN = Pattern.compile("/$");
    static final Pattern MULTIPLE_SLASH_PATTERN = Pattern.compile("//+");

    private JerseyTags() {
    }

    public static Tag method(ContainerRequest containerRequest) {
        return containerRequest != null ? Tag.of("method", containerRequest.getMethod()) : METHOD_UNKNOWN;
    }

    public static Tag status(ContainerResponse containerResponse) {
        return containerResponse != null ? Tag.of("status", Integer.toString(containerResponse.getStatus())) : STATUS_SERVER_ERROR;
    }

    public static Tag uri(RequestEvent requestEvent) {
        String string;
        ContainerResponse containerResponse = requestEvent.getContainerResponse();
        if (containerResponse != null) {
            int n2 = containerResponse.getStatus();
            if (JerseyTags.isRedirection(n2) && requestEvent.getUriInfo().getMatchedResourceMethod() == null) {
                return URI_REDIRECTION;
            }
            if (n2 == 404 && requestEvent.getUriInfo().getMatchedResourceMethod() == null) {
                return URI_NOT_FOUND;
            }
        }
        if ((string = JerseyTags.getMatchingPattern(requestEvent)).equals("/")) {
            return URI_ROOT;
        }
        return Tag.of("uri", string);
    }

    static boolean isRedirection(int n2) {
        return 300 <= n2 && n2 < 400;
    }

    static String getMatchingPattern(RequestEvent requestEvent) {
        ExtendedUriInfo extendedUriInfo = requestEvent.getUriInfo();
        List list = extendedUriInfo.getMatchedTemplates();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(extendedUriInfo.getBaseUri().getPath());
        for (int i2 = list.size() - 1; i2 >= 0; --i2) {
            stringBuilder.append(((UriTemplate)list.get(i2)).getTemplate());
        }
        String string = MULTIPLE_SLASH_PATTERN.matcher(stringBuilder.toString()).replaceAll("/");
        if (string.equals("/")) {
            return string;
        }
        return TRAILING_SLASH_PATTERN.matcher(string).replaceAll("");
    }

    public static Tag exception(RequestEvent requestEvent) {
        String string;
        int n2;
        Throwable throwable = requestEvent.getException();
        if (throwable == null) {
            return EXCEPTION_NONE;
        }
        ContainerResponse containerResponse = requestEvent.getContainerResponse();
        if (containerResponse != null && ((n2 = containerResponse.getStatus()) == 404 || JerseyTags.isRedirection(n2))) {
            return EXCEPTION_NONE;
        }
        if (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        return Tag.of("exception", StringUtils.isNotEmpty(string = throwable.getClass().getSimpleName()) ? string : throwable.getClass().getName());
    }

    public static Tag outcome(ContainerResponse containerResponse) {
        if (containerResponse != null) {
            return Outcome.forStatus(containerResponse.getStatus()).asTag();
        }
        return Outcome.SERVER_ERROR.asTag();
    }
}

