/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.instrument.binder.jersey.server;

import com.contrastsecurity.thirdparty.imm.core.annotation.Timed;
import com.contrastsecurity.thirdparty.imm.core.instrument.LongTaskTimer;
import com.contrastsecurity.thirdparty.imm.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.imm.core.instrument.Timer;
import com.contrastsecurity.thirdparty.imm.core.instrument.binder.jersey.server.AnnotationFinder;
import com.contrastsecurity.thirdparty.imm.core.instrument.binder.jersey.server.JerseyTagsProvider;
import com.contrastsecurity.thirdparty.imm.core.instrument.binder.jersey.server.TimedFinder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.monitoring.RequestEvent;
import org.glassfish.jersey.server.monitoring.RequestEventListener;

public class MetricsRequestEventListener
implements RequestEventListener {
    private final Map<ContainerRequest, Timer.Sample> shortTaskSample = Collections.synchronizedMap(new IdentityHashMap());
    private final Map<ContainerRequest, Collection<LongTaskTimer.Sample>> longTaskSamples = Collections.synchronizedMap(new IdentityHashMap());
    private final Map<ContainerRequest, Set<Timed>> timedAnnotationsOnRequest = Collections.synchronizedMap(new IdentityHashMap());
    private final MeterRegistry registry;
    private final JerseyTagsProvider tagsProvider;
    private boolean autoTimeRequests;
    private final TimedFinder timedFinder;
    private final String metricName;

    public MetricsRequestEventListener(MeterRegistry meterRegistry, JerseyTagsProvider jerseyTagsProvider, String string, boolean bl2, AnnotationFinder annotationFinder) {
        this.registry = Objects.requireNonNull(meterRegistry);
        this.tagsProvider = Objects.requireNonNull(jerseyTagsProvider);
        this.metricName = Objects.requireNonNull(string);
        this.autoTimeRequests = bl2;
        this.timedFinder = new TimedFinder(annotationFinder);
    }

    public void onEvent(RequestEvent requestEvent) {
        ContainerRequest containerRequest = requestEvent.getContainerRequest();
        switch (requestEvent.getType()) {
            case ON_EXCEPTION: {
                if (!this.isNotFoundException(requestEvent)) break;
            }
            case REQUEST_MATCHED: {
                Set<Timed> set = this.annotations(requestEvent);
                this.timedAnnotationsOnRequest.put(containerRequest, set);
                this.shortTaskSample.put(containerRequest, Timer.start(this.registry));
                List list = this.longTaskTimers(set, requestEvent).stream().map(LongTaskTimer::start).collect(Collectors.toList());
                if (list.isEmpty()) break;
                this.longTaskSamples.put(containerRequest, list);
                break;
            }
            case FINISHED: {
                Object object;
                Object object2;
                Set<Timed> set = this.timedAnnotationsOnRequest.remove(containerRequest);
                Timer.Sample sample = this.shortTaskSample.remove(containerRequest);
                if (sample != null) {
                    object2 = this.shortTimers(set, requestEvent).iterator();
                    while (object2.hasNext()) {
                        object = (Timer)object2.next();
                        sample.stop((Timer)object);
                    }
                }
                if ((object2 = this.longTaskSamples.remove(containerRequest)) == null) break;
                object = object2.iterator();
                while (object.hasNext()) {
                    LongTaskTimer.Sample sample2 = (LongTaskTimer.Sample)object.next();
                    sample2.stop();
                }
                break;
            }
        }
    }

    private boolean isNotFoundException(RequestEvent requestEvent) {
        Throwable throwable = requestEvent.getException();
        if (throwable == null) {
            return false;
        }
        String string = throwable.getClass().getCanonicalName();
        return string.equals("jakarta.ws.rs.NotFoundException") || string.equals("javax.ws.rs.NotFoundException");
    }

    private Set<Timer> shortTimers(Set<Timed> set, RequestEvent requestEvent) {
        if ((set == null || set.isEmpty()) && this.autoTimeRequests) {
            return Collections.singleton(this.registry.timer(this.metricName, this.tagsProvider.httpRequestTags(requestEvent)));
        }
        if (set == null) {
            return Collections.emptySet();
        }
        return set.stream().filter(timed -> !timed.longTask()).map(timed -> ((Timer.Builder)Timer.builder(timed, this.metricName).tags((Iterable)this.tagsProvider.httpRequestTags(requestEvent))).register(this.registry)).collect(Collectors.toSet());
    }

    private Set<LongTaskTimer> longTaskTimers(Set<Timed> set, RequestEvent requestEvent) {
        return set.stream().filter(Timed::longTask).map(LongTaskTimer::builder).map(builder -> builder.tags(this.tagsProvider.httpLongRequestTags(requestEvent)).register(this.registry)).collect(Collectors.toSet());
    }

    private Set<Timed> annotations(RequestEvent requestEvent) {
        HashSet<Timed> hashSet = new HashSet<Timed>();
        ResourceMethod resourceMethod = requestEvent.getUriInfo().getMatchedResourceMethod();
        if (resourceMethod != null) {
            hashSet.addAll(this.timedFinder.findTimedAnnotations(resourceMethod.getInvocable().getHandlingMethod()));
            if (hashSet.isEmpty()) {
                hashSet.addAll(this.timedFinder.findTimedAnnotations(resourceMethod.getInvocable().getHandlingMethod().getDeclaringClass()));
            }
        }
        return hashSet;
    }
}

