/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.instrument.binder.jetty;

import com.contrastsecurity.thirdparty.imm.common.util.StringUtils;
import com.contrastsecurity.thirdparty.imm.core.instrument.Tag;
import com.contrastsecurity.thirdparty.imm.core.instrument.binder.http.Outcome;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.http.HttpStatus;

public final class JettyClientTags {
    private static final Tag URI_NOT_FOUND = Tag.of("uri", "NOT_FOUND");
    private static final Tag URI_REDIRECTION = Tag.of("uri", "REDIRECTION");
    private static final Tag URI_ROOT = Tag.of("uri", "root");
    private static final Tag EXCEPTION_NONE = Tag.of("exception", "None");
    private static final Tag METHOD_UNKNOWN = Tag.of("method", "UNKNOWN");
    private static final Tag HOST_UNKNOWN = Tag.of("host", "UNKNOWN");
    private static final Pattern TRAILING_SLASH_PATTERN = Pattern.compile("/$");
    private static final Pattern MULTIPLE_SLASH_PATTERN = Pattern.compile("//+");

    private JettyClientTags() {
    }

    public static Tag method(Request request) {
        return request != null ? Tag.of("method", request.getMethod()) : METHOD_UNKNOWN;
    }

    public static Tag host(Request request) {
        return request != null ? Tag.of("host", request.getHost()) : HOST_UNKNOWN;
    }

    public static Tag status(Result result) {
        return Tag.of("status", Integer.toString(result.getResponse().getStatus()));
    }

    public static Tag uri(Result result, Function<Result, String> function) {
        Response response = result.getResponse();
        if (response != null) {
            int n2 = response.getStatus();
            if (HttpStatus.isRedirection((int)n2)) {
                return URI_REDIRECTION;
            }
            if (n2 == 404) {
                return URI_NOT_FOUND;
            }
        }
        String string = function.apply(result);
        if ((string = MULTIPLE_SLASH_PATTERN.matcher(string).replaceAll("/")).equals("/")) {
            return URI_ROOT;
        }
        string = TRAILING_SLASH_PATTERN.matcher(string).replaceAll("");
        return Tag.of("uri", string);
    }

    public static Tag exception(Result result) {
        String string;
        int n2;
        Throwable throwable = result.getFailure();
        if (throwable == null) {
            return EXCEPTION_NONE;
        }
        if (result.getResponse() != null && ((n2 = result.getResponse().getStatus()) == 404 || HttpStatus.isRedirection((int)n2))) {
            return EXCEPTION_NONE;
        }
        if (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        return Tag.of("exception", StringUtils.isNotEmpty(string = throwable.getClass().getSimpleName()) ? string : throwable.getClass().getName());
    }

    public static Tag outcome(Result result) {
        return Outcome.forStatus(result.getResponse().getStatus()).asTag();
    }
}

