/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.instrument.binder.jetty;

import com.contrastsecurity.thirdparty.imm.core.instrument.Counter;
import com.contrastsecurity.thirdparty.imm.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.imm.core.instrument.Tag;
import com.contrastsecurity.thirdparty.imm.core.instrument.Tags;
import javax.net.ssl.SSLSession;
import org.eclipse.jetty.io.ssl.SslHandshakeListener;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;

public class JettySslHandshakeMetrics
implements SslHandshakeListener {
    private static final String METER_NAME = "jetty.ssl.handshakes";
    private static final String DESCRIPTION = "SSL/TLS handshakes";
    private static final String TAG_RESULT = "result";
    private static final String TAG_PROTOCOL = "protocol";
    private static final String TAG_CIPHER_SUITE = "ciphersuite";
    private static final String TAG_VALUE_UNKNOWN = "unknown";
    private final MeterRegistry registry;
    private final Iterable<Tag> tags;
    private final Counter handshakesFailed;

    public JettySslHandshakeMetrics(MeterRegistry meterRegistry) {
        this(meterRegistry, Tags.empty());
    }

    public JettySslHandshakeMetrics(MeterRegistry meterRegistry, Iterable<Tag> iterable) {
        this.registry = meterRegistry;
        this.tags = iterable;
        this.handshakesFailed = Counter.builder(METER_NAME).baseUnit("events").description(DESCRIPTION).tag(TAG_RESULT, "failed").tag(TAG_PROTOCOL, TAG_VALUE_UNKNOWN).tag(TAG_CIPHER_SUITE, TAG_VALUE_UNKNOWN).tags(iterable).register(meterRegistry);
    }

    public JettySslHandshakeMetrics(MeterRegistry meterRegistry, Connector connector) {
        this(meterRegistry, connector, Tags.empty());
    }

    public JettySslHandshakeMetrics(MeterRegistry meterRegistry, Connector connector, Iterable<Tag> iterable) {
        this(meterRegistry, JettySslHandshakeMetrics.getConnectorNameTag(connector).and(iterable));
    }

    private static Tags getConnectorNameTag(Connector connector) {
        String string = connector.getName();
        return Tags.of("connector.name", string != null ? string : "unnamed");
    }

    public void handshakeSucceeded(SslHandshakeListener.Event event) {
        SSLSession sSLSession = event.getSSLEngine().getSession();
        Counter.builder(METER_NAME).baseUnit("events").description(DESCRIPTION).tag(TAG_RESULT, "succeeded").tag(TAG_PROTOCOL, sSLSession.getProtocol()).tag(TAG_CIPHER_SUITE, sSLSession.getCipherSuite()).tags(this.tags).register(this.registry).increment();
    }

    public void handshakeFailed(SslHandshakeListener.Event event, Throwable throwable) {
        this.handshakesFailed.increment();
    }

    public static void addToAllConnectors(Server server, MeterRegistry meterRegistry, Iterable<Tag> iterable) {
        for (Connector connector : server.getConnectors()) {
            if (connector == null) continue;
            connector.addBean((Object)new JettySslHandshakeMetrics(meterRegistry, connector, iterable));
        }
    }

    public static void addToAllConnectors(Server server, MeterRegistry meterRegistry) {
        JettySslHandshakeMetrics.addToAllConnectors(server, meterRegistry, Tags.empty());
    }
}

