/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.instrument.binder.jetty;

import com.contrastsecurity.thirdparty.imm.common.lang.NonNullApi;
import com.contrastsecurity.thirdparty.imm.common.lang.NonNullFields;
import com.contrastsecurity.thirdparty.imm.core.instrument.FunctionCounter;
import com.contrastsecurity.thirdparty.imm.core.instrument.FunctionTimer;
import com.contrastsecurity.thirdparty.imm.core.instrument.Gauge;
import com.contrastsecurity.thirdparty.imm.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.imm.core.instrument.Tag;
import com.contrastsecurity.thirdparty.imm.core.instrument.Tags;
import com.contrastsecurity.thirdparty.imm.core.instrument.TimeGauge;
import com.contrastsecurity.thirdparty.imm.core.instrument.binder.MeterBinder;
import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;
import org.eclipse.jetty.server.handler.StatisticsHandler;

@Deprecated
@NonNullApi
@NonNullFields
public class JettyStatisticsMetrics
implements MeterBinder {
    private final StatisticsHandler statisticsHandler;
    private Iterable<Tag> tags;

    public JettyStatisticsMetrics(StatisticsHandler statisticsHandler, Iterable<Tag> iterable) {
        this.tags = iterable;
        this.statisticsHandler = statisticsHandler;
    }

    public static void monitor(MeterRegistry meterRegistry, StatisticsHandler statisticsHandler, String ... stringArray) {
        JettyStatisticsMetrics.monitor(meterRegistry, statisticsHandler, Tags.of(stringArray));
    }

    public static void monitor(MeterRegistry meterRegistry, StatisticsHandler statisticsHandler, Iterable<Tag> iterable) {
        new JettyStatisticsMetrics(statisticsHandler, iterable).bindTo(meterRegistry);
    }

    @Override
    public void bindTo(MeterRegistry meterRegistry) {
        this.bindTimer(meterRegistry, "jetty.requests", "Request duration", StatisticsHandler::getRequests, StatisticsHandler::getRequestTimeTotal);
        this.bindTimer(meterRegistry, "jetty.dispatched", "Dispatch duration", StatisticsHandler::getDispatched, StatisticsHandler::getDispatchedTimeTotal);
        this.bindCounter(meterRegistry, "jetty.async.requests", "Total number of async requests", StatisticsHandler::getAsyncRequests);
        this.bindCounter(meterRegistry, "jetty.async.dispatches", "Total number of requests that have been asynchronously dispatched", StatisticsHandler::getAsyncDispatches);
        this.bindCounter(meterRegistry, "jetty.async.expires", "Total number of async requests that have expired", StatisticsHandler::getExpires);
        FunctionCounter.builder("jetty.responses.size", this.statisticsHandler, StatisticsHandler::getResponsesBytesTotal).description("Total number of bytes across all responses").baseUnit("bytes").tags(this.tags).register(meterRegistry);
        this.bindGauge(meterRegistry, "jetty.requests.active", "Number of requests currently active", StatisticsHandler::getRequestsActive);
        this.bindGauge(meterRegistry, "jetty.dispatched.active", "Number of dispatches currently active", StatisticsHandler::getDispatchedActive);
        this.bindGauge(meterRegistry, "jetty.dispatched.active.max", "Maximum number of active dispatches being handled", StatisticsHandler::getDispatchedActiveMax);
        this.bindTimeGauge(meterRegistry, "jetty.dispatched.time.max", "Maximum time spent in dispatch handling", StatisticsHandler::getDispatchedTimeMax);
        this.bindGauge(meterRegistry, "jetty.async.requests.waiting", "Currently waiting async requests", StatisticsHandler::getAsyncRequestsWaiting);
        this.bindGauge(meterRegistry, "jetty.async.requests.waiting.max", "Maximum number of waiting async requests", StatisticsHandler::getAsyncRequestsWaitingMax);
        this.bindTimeGauge(meterRegistry, "jetty.request.time.max", "Maximum time spent handling requests", StatisticsHandler::getRequestTimeMax);
        this.bindTimeGauge(meterRegistry, "jetty.stats", "Time stats have been collected for", StatisticsHandler::getStatsOnMs);
        this.bindStatusCounters(meterRegistry);
    }

    private void bindStatusCounters(MeterRegistry meterRegistry) {
        this.buildStatusCounter(meterRegistry, "1xx", StatisticsHandler::getResponses1xx);
        this.buildStatusCounter(meterRegistry, "2xx", StatisticsHandler::getResponses2xx);
        this.buildStatusCounter(meterRegistry, "3xx", StatisticsHandler::getResponses3xx);
        this.buildStatusCounter(meterRegistry, "4xx", StatisticsHandler::getResponses4xx);
        this.buildStatusCounter(meterRegistry, "5xx", StatisticsHandler::getResponses5xx);
    }

    private void bindGauge(MeterRegistry meterRegistry, String string, String string2, ToDoubleFunction<StatisticsHandler> toDoubleFunction) {
        Gauge.builder(string, this.statisticsHandler, toDoubleFunction).tags(this.tags).description(string2).register(meterRegistry);
    }

    private void bindTimer(MeterRegistry meterRegistry, String string, String string2, ToLongFunction<StatisticsHandler> toLongFunction, ToDoubleFunction<StatisticsHandler> toDoubleFunction) {
        FunctionTimer.builder(string, this.statisticsHandler, toLongFunction, toDoubleFunction, TimeUnit.MILLISECONDS).tags(this.tags).description(string2).register(meterRegistry);
    }

    private void bindTimeGauge(MeterRegistry meterRegistry, String string, String string2, ToDoubleFunction<StatisticsHandler> toDoubleFunction) {
        TimeGauge.builder(string, this.statisticsHandler, TimeUnit.MILLISECONDS, toDoubleFunction).tags(this.tags).description(string2).register(meterRegistry);
    }

    private void bindCounter(MeterRegistry meterRegistry, String string, String string2, ToDoubleFunction<StatisticsHandler> toDoubleFunction) {
        FunctionCounter.builder(string, this.statisticsHandler, toDoubleFunction).tags(this.tags).description(string2).register(meterRegistry);
    }

    private void buildStatusCounter(MeterRegistry meterRegistry, String string, ToDoubleFunction<StatisticsHandler> toDoubleFunction) {
        FunctionCounter.builder("jetty.responses", this.statisticsHandler, toDoubleFunction).tags(this.tags).description("Number of requests with response status").tags("status", string).register(meterRegistry);
    }
}

