/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.instrument.binder.jvm;

import com.contrastsecurity.thirdparty.imm.common.lang.NonNullApi;
import com.contrastsecurity.thirdparty.imm.common.lang.NonNullFields;
import com.contrastsecurity.thirdparty.imm.core.instrument.Gauge;
import com.contrastsecurity.thirdparty.imm.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.imm.core.instrument.Tag;
import com.contrastsecurity.thirdparty.imm.core.instrument.Tags;
import com.contrastsecurity.thirdparty.imm.core.instrument.binder.MeterBinder;
import com.contrastsecurity.thirdparty.imm.core.instrument.binder.jvm.JvmMemory;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.util.Collections;

@NonNullApi
@NonNullFields
public class JvmMemoryMetrics
implements MeterBinder {
    private final Iterable<Tag> tags;

    public JvmMemoryMetrics() {
        this(Collections.emptyList());
    }

    public JvmMemoryMetrics(Iterable<Tag> iterable) {
        this.tags = iterable;
    }

    @Override
    public void bindTo(MeterRegistry meterRegistry) {
        Object object;
        for (BufferPoolMXBean platformManagedObject : ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class)) {
            object = Tags.concat(this.tags, "id", platformManagedObject.getName());
            Gauge.builder("jvm.buffer.count", platformManagedObject, BufferPoolMXBean::getCount).tags((Iterable<Tag>)object).description("An estimate of the number of buffers in the pool").baseUnit("buffers").register(meterRegistry);
            Gauge.builder("jvm.buffer.memory.used", platformManagedObject, BufferPoolMXBean::getMemoryUsed).tags((Iterable<Tag>)object).description("An estimate of the memory that the Java virtual machine is using for this buffer pool").baseUnit("bytes").register(meterRegistry);
            Gauge.builder("jvm.buffer.total.capacity", platformManagedObject, BufferPoolMXBean::getTotalCapacity).tags((Iterable<Tag>)object).description("An estimate of the total capacity of the buffers in this pool").baseUnit("bytes").register(meterRegistry);
        }
        for (MemoryPoolMXBean memoryPoolMXBean2 : ManagementFactory.getPlatformMXBeans(MemoryPoolMXBean.class)) {
            object = MemoryType.HEAP.equals((Object)memoryPoolMXBean2.getType()) ? "heap" : "nonheap";
            Tags tags = Tags.concat(this.tags, new String[]{"id", memoryPoolMXBean2.getName(), "area", object});
            Gauge.builder("jvm.memory.used", memoryPoolMXBean2, memoryPoolMXBean -> JvmMemory.getUsageValue(memoryPoolMXBean, MemoryUsage::getUsed)).tags(tags).description("The amount of used memory").baseUnit("bytes").register(meterRegistry);
            Gauge.builder("jvm.memory.committed", memoryPoolMXBean2, memoryPoolMXBean -> JvmMemory.getUsageValue(memoryPoolMXBean, MemoryUsage::getCommitted)).tags(tags).description("The amount of memory in bytes that is committed for the Java virtual machine to use").baseUnit("bytes").register(meterRegistry);
            Gauge.builder("jvm.memory.max", memoryPoolMXBean2, memoryPoolMXBean -> JvmMemory.getUsageValue(memoryPoolMXBean, MemoryUsage::getMax)).tags(tags).description("The maximum amount of memory in bytes that can be used for memory management").baseUnit("bytes").register(meterRegistry);
        }
    }
}

