/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.instrument.binder.kafka;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.imm.common.lang.NonNullApi;
import com.contrastsecurity.thirdparty.imm.common.lang.NonNullFields;
import com.contrastsecurity.thirdparty.imm.common.lang.Nullable;
import com.contrastsecurity.thirdparty.imm.core.annotation.Incubating;
import com.contrastsecurity.thirdparty.imm.core.instrument.FunctionCounter;
import com.contrastsecurity.thirdparty.imm.core.instrument.Gauge;
import com.contrastsecurity.thirdparty.imm.core.instrument.Meter;
import com.contrastsecurity.thirdparty.imm.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.imm.core.instrument.Tag;
import com.contrastsecurity.thirdparty.imm.core.instrument.Tags;
import com.contrastsecurity.thirdparty.imm.core.instrument.TimeGauge;
import com.contrastsecurity.thirdparty.imm.core.instrument.binder.MeterBinder;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.ToDoubleFunction;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerFactory;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

@NonNullApi
@NonNullFields
@Deprecated
@Incubating(since="1.1.0")
public class KafkaConsumerMetrics
implements MeterBinder,
AutoCloseable {
    private static final String JMX_DOMAIN = "kafka.consumer";
    private static final String METRIC_NAME_PREFIX = "kafka.consumer.";
    private final MBeanServer mBeanServer;
    private final Iterable<Tag> tags;
    @Nullable
    private Integer kafkaMajorVersion;
    private final List<Runnable> notificationListenerCleanUpRunnables = new CopyOnWriteArrayList<Runnable>();

    public KafkaConsumerMetrics() {
        this(Collections.emptyList());
    }

    public KafkaConsumerMetrics(Iterable<Tag> iterable) {
        this(KafkaConsumerMetrics.getMBeanServer(), iterable);
    }

    public KafkaConsumerMetrics(MBeanServer mBeanServer, Iterable<Tag> iterable) {
        this.mBeanServer = mBeanServer;
        this.tags = iterable;
    }

    private static MBeanServer getMBeanServer() {
        ArrayList<MBeanServer> arrayList = MBeanServerFactory.findMBeanServer(null);
        if (!arrayList.isEmpty()) {
            return (MBeanServer)arrayList.get(0);
        }
        return ManagementFactory.getPlatformMBeanServer();
    }

    @Override
    public void bindTo(MeterRegistry meterRegistry) {
        this.registerMetricsEventually(meterRegistry, "consumer-fetch-manager-metrics", (objectName, tags) -> {
            ArrayList<Meter> arrayList = new ArrayList<Meter>();
            if (tags.stream().anyMatch(tag -> tag.getKey().equals("topic")) && tags.stream().anyMatch(tag -> tag.getKey().equals("partition"))) {
                arrayList.add(this.registerGaugeForObject(meterRegistry, (ObjectName)objectName, "records-lag", (Tags)tags, "The latest lag of the partition", "records"));
                arrayList.add(this.registerGaugeForObject(meterRegistry, (ObjectName)objectName, "records-lag-avg", (Tags)tags, "The average lag of the partition", "records"));
                arrayList.add(this.registerGaugeForObject(meterRegistry, (ObjectName)objectName, "records-lag-max", (Tags)tags, "The maximum lag in terms of number of records for any partition in this window. An increasing value over time is your best indication that the consumer group is not keeping up with the producers.", "records"));
                if (this.kafkaMajorVersion((Tags)tags) >= 2) {
                    arrayList.add(this.registerGaugeForObject(meterRegistry, (ObjectName)objectName, "records-lead", (Tags)tags, "The latest lead of the partition.", "records"));
                    arrayList.add(this.registerGaugeForObject(meterRegistry, (ObjectName)objectName, "records-lead-min", (Tags)tags, "The min lead of the partition. The lag between the consumer offset and the start offset of the log. If this gets close to zero, it's an indication that the consumer may lose data soon.", "records"));
                    arrayList.add(this.registerGaugeForObject(meterRegistry, (ObjectName)objectName, "records-lead-avg", (Tags)tags, "The average lead of the partition.", "records"));
                }
            } else if (tags.stream().anyMatch(tag -> tag.getKey().equals("topic"))) {
                arrayList.add(this.registerGaugeForObject(meterRegistry, (ObjectName)objectName, "fetch-size-avg", (Tags)tags, "The average number of bytes fetched per request.", "bytes"));
                arrayList.add(this.registerGaugeForObject(meterRegistry, (ObjectName)objectName, "fetch-size-max", (Tags)tags, "The maximum number of bytes fetched per request.", "bytes"));
                arrayList.add(this.registerGaugeForObject(meterRegistry, (ObjectName)objectName, "records-per-request-avg", (Tags)tags, "The average number of records in each request.", "records"));
                arrayList.add(this.registerFunctionCounterForObject(meterRegistry, (ObjectName)objectName, "bytes-consumed-total", (Tags)tags, "The total number of bytes consumed.", "bytes"));
                arrayList.add(this.registerFunctionCounterForObject(meterRegistry, (ObjectName)objectName, "records-consumed-total", (Tags)tags, "The total number of records consumed.", "records"));
            } else {
                arrayList.add(this.registerFunctionCounterForObject(meterRegistry, (ObjectName)objectName, "fetch-total", (Tags)tags, "The number of fetch requests.", "requests"));
                arrayList.add(this.registerTimeGaugeForObject(meterRegistry, (ObjectName)objectName, "fetch-latency-avg", (Tags)tags, "The average time taken for a fetch request."));
                arrayList.add(this.registerTimeGaugeForObject(meterRegistry, (ObjectName)objectName, "fetch-latency-max", (Tags)tags, "The max time taken for a fetch request."));
                arrayList.add(this.registerTimeGaugeForObject(meterRegistry, (ObjectName)objectName, "fetch-throttle-time-avg", (Tags)tags, "The average throttle time. When quotas are enabled, the broker may delay fetch requests in order to throttle a consumer which has exceeded its limit. This metric indicates how throttling time has been added to fetch requests on average."));
                arrayList.add(this.registerTimeGaugeForObject(meterRegistry, (ObjectName)objectName, "fetch-throttle-time-max", (Tags)tags, "The maximum throttle time."));
            }
            return arrayList;
        });
        this.registerMetricsEventually(meterRegistry, "consumer-coordinator-metrics", (objectName, tags) -> {
            ArrayList<Gauge> arrayList = new ArrayList<Gauge>();
            arrayList.add(this.registerGaugeForObject(meterRegistry, (ObjectName)objectName, "assigned-partitions", (Tags)tags, "The number of partitions currently assigned to this consumer.", "partitions"));
            arrayList.add(this.registerGaugeForObject(meterRegistry, (ObjectName)objectName, "commit-rate", (Tags)tags, "The number of commit calls per second.", "commits"));
            arrayList.add(this.registerGaugeForObject(meterRegistry, (ObjectName)objectName, "join-rate", (Tags)tags, "The number of group joins per second. Group joining is the first phase of the rebalance protocol. A large value indicates that the consumer group is unstable and will likely be coupled with increased lag.", "joins"));
            arrayList.add(this.registerGaugeForObject(meterRegistry, (ObjectName)objectName, "sync-rate", (Tags)tags, "The number of group syncs per second. Group synchronization is the second and last phase of the rebalance protocol. A large value indicates group instability.", "syncs"));
            arrayList.add(this.registerGaugeForObject(meterRegistry, (ObjectName)objectName, "heartbeat-rate", (Tags)tags, "The average number of heartbeats per second. After a rebalance, the consumer sends heartbeats to the coordinator to keep itself active in the group. You may see a lower rate than configured if the processing loop is taking more time to handle message batches. Usually this is OK as long as you see no increase in the join rate.", "heartbeats"));
            arrayList.add(this.registerTimeGaugeForObject(meterRegistry, (ObjectName)objectName, "commit-latency-avg", (Tags)tags, "The average time taken for a commit request."));
            arrayList.add(this.registerTimeGaugeForObject(meterRegistry, (ObjectName)objectName, "commit-latency-max", (Tags)tags, "The max time taken for a commit request."));
            arrayList.add(this.registerTimeGaugeForObject(meterRegistry, (ObjectName)objectName, "join-time-avg", (Tags)tags, "The average time taken for a group rejoin. This value can get as high as the configured session timeout for the consumer, but should usually be lower."));
            arrayList.add(this.registerTimeGaugeForObject(meterRegistry, (ObjectName)objectName, "join-time-max", (Tags)tags, "The max time taken for a group rejoin. This value should not get much higher than the configured session timeout for the consumer."));
            arrayList.add(this.registerTimeGaugeForObject(meterRegistry, (ObjectName)objectName, "sync-time-avg", (Tags)tags, "The average time taken for a group sync."));
            arrayList.add(this.registerTimeGaugeForObject(meterRegistry, (ObjectName)objectName, "sync-time-max", (Tags)tags, "The max time taken for a group sync."));
            arrayList.add(this.registerTimeGaugeForObject(meterRegistry, (ObjectName)objectName, "heartbeat-response-time-max", (Tags)tags, "The max time taken to receive a response to a heartbeat request."));
            arrayList.add(this.registerTimeGaugeForObject(meterRegistry, (ObjectName)objectName, "last-heartbeat-seconds-ago", "last-heartbeat", (Tags)tags, "The time since the last controller heartbeat.", TimeUnit.SECONDS));
            return arrayList;
        });
        this.registerMetricsEventually(meterRegistry, "consumer-metrics", (objectName, tags) -> {
            ArrayList<Gauge> arrayList = new ArrayList<Gauge>();
            arrayList.add(this.registerGaugeForObject(meterRegistry, (ObjectName)objectName, "connection-count", (Tags)tags, "The current number of active connections.", "connections"));
            arrayList.add(this.registerGaugeForObject(meterRegistry, (ObjectName)objectName, "connection-creation-total", (Tags)tags, "New connections established.", "connections"));
            arrayList.add(this.registerGaugeForObject(meterRegistry, (ObjectName)objectName, "connection-close-total", (Tags)tags, "Connections closed.", "connections"));
            arrayList.add(this.registerGaugeForObject(meterRegistry, (ObjectName)objectName, "io-ratio", (Tags)tags, "The fraction of time the I/O thread spent doing I/O.", null));
            arrayList.add(this.registerGaugeForObject(meterRegistry, (ObjectName)objectName, "io-wait-ratio", (Tags)tags, "The fraction of time the I/O thread spent waiting.", null));
            arrayList.add(this.registerGaugeForObject(meterRegistry, (ObjectName)objectName, "select-total", (Tags)tags, "Number of times the I/O layer checked for new I/O to perform.", null));
            arrayList.add(this.registerTimeGaugeForObject(meterRegistry, (ObjectName)objectName, "io-time-ns-avg", "io-time-avg", (Tags)tags, "The average length of time for I/O per select call.", TimeUnit.NANOSECONDS));
            arrayList.add(this.registerTimeGaugeForObject(meterRegistry, (ObjectName)objectName, "io-wait-time-ns-avg", "io-wait-time-avg", (Tags)tags, "The average length of time the I/O thread spent waiting for a socket to be ready for reads or writes.", TimeUnit.NANOSECONDS));
            if (this.kafkaMajorVersion((Tags)tags) >= 2) {
                arrayList.add(this.registerGaugeForObject(meterRegistry, (ObjectName)objectName, "successful-authentication-total", "authentication-attempts", Tags.concat((Iterable<? extends Tag>)tags, "result", "successful"), "The number of successful authentication attempts.", null));
                arrayList.add(this.registerGaugeForObject(meterRegistry, (ObjectName)objectName, "failed-authentication-total", "authentication-attempts", Tags.concat((Iterable<? extends Tag>)tags, "result", "failed"), "The number of failed authentication attempts.", null));
                arrayList.add(this.registerGaugeForObject(meterRegistry, (ObjectName)objectName, "network-io-total", (Tags)tags, "", "bytes"));
                arrayList.add(this.registerGaugeForObject(meterRegistry, (ObjectName)objectName, "outgoing-byte-total", (Tags)tags, "", "bytes"));
                arrayList.add(this.registerGaugeForObject(meterRegistry, (ObjectName)objectName, "request-total", (Tags)tags, "", "requests"));
                arrayList.add(this.registerGaugeForObject(meterRegistry, (ObjectName)objectName, "response-total", (Tags)tags, "", "responses"));
                arrayList.add(this.registerTimeGaugeForObject(meterRegistry, (ObjectName)objectName, "io-waittime-total", "io-wait-time-total", (Tags)tags, "Time spent on the I/O thread waiting for a socket to be ready for reads or writes.", TimeUnit.NANOSECONDS));
                arrayList.add(this.registerTimeGaugeForObject(meterRegistry, (ObjectName)objectName, "iotime-total", "io-time-total", (Tags)tags, "Time spent in I/O during select calls.", TimeUnit.NANOSECONDS));
            }
            return arrayList;
        });
    }

    private Gauge registerGaugeForObject(MeterRegistry meterRegistry, ObjectName objectName, String string, String string2, Tags tags, String string3, @Nullable String string4) {
        AtomicReference<Gauge> atomicReference = new AtomicReference<Gauge>();
        Gauge gauge = Gauge.builder(METRIC_NAME_PREFIX + string2, this.mBeanServer, this.getJmxAttribute(meterRegistry, atomicReference, objectName, string)).description(string3).baseUnit(string4).tags(tags).register(meterRegistry);
        atomicReference.set(gauge);
        return gauge;
    }

    private Gauge registerGaugeForObject(MeterRegistry meterRegistry, ObjectName objectName, String string, Tags tags, String string2, @Nullable String string3) {
        return this.registerGaugeForObject(meterRegistry, objectName, string, KafkaConsumerMetrics.sanitize(string), tags, string2, string3);
    }

    private FunctionCounter registerFunctionCounterForObject(MeterRegistry meterRegistry, ObjectName objectName, String string, Tags tags, String string2, @Nullable String string3) {
        AtomicReference<FunctionCounter> atomicReference = new AtomicReference<FunctionCounter>();
        FunctionCounter functionCounter = FunctionCounter.builder(METRIC_NAME_PREFIX + KafkaConsumerMetrics.sanitize(string), this.mBeanServer, this.getJmxAttribute(meterRegistry, atomicReference, objectName, string)).description(string2).baseUnit(string3).tags(tags).register(meterRegistry);
        atomicReference.set(functionCounter);
        return functionCounter;
    }

    private TimeGauge registerTimeGaugeForObject(MeterRegistry meterRegistry, ObjectName objectName, String string, String string2, Tags tags, String string3, TimeUnit timeUnit) {
        AtomicReference<TimeGauge> atomicReference = new AtomicReference<TimeGauge>();
        TimeGauge timeGauge = TimeGauge.builder(METRIC_NAME_PREFIX + string2, this.mBeanServer, timeUnit, this.getJmxAttribute(meterRegistry, atomicReference, objectName, string)).description(string3).tags(tags).register(meterRegistry);
        atomicReference.set(timeGauge);
        return timeGauge;
    }

    private TimeGauge registerTimeGaugeForObject(MeterRegistry meterRegistry, ObjectName objectName, String string, String string2, Tags tags, String string3) {
        return this.registerTimeGaugeForObject(meterRegistry, objectName, string, string2, tags, string3, TimeUnit.MILLISECONDS);
    }

    private ToDoubleFunction<MBeanServer> getJmxAttribute(MeterRegistry meterRegistry, AtomicReference<? extends Meter> atomicReference, ObjectName objectName, String string) {
        return mBeanServer -> this.safeDouble(() -> {
            if (!mBeanServer.isRegistered(objectName)) {
                meterRegistry.remove((Meter)atomicReference.get());
            }
            return mBeanServer.getAttribute(objectName, string);
        });
    }

    private TimeGauge registerTimeGaugeForObject(MeterRegistry meterRegistry, ObjectName objectName, String string, Tags tags, String string2) {
        return this.registerTimeGaugeForObject(meterRegistry, objectName, string, KafkaConsumerMetrics.sanitize(string), tags, string2);
    }

    int kafkaMajorVersion(Tags tags) {
        if (this.kafkaMajorVersion == null || this.kafkaMajorVersion == -1) {
            this.kafkaMajorVersion = tags.stream().filter(tag -> "client.id".equals(tag.getKey())).findAny().map(tag -> {
                try {
                    String string = (String)this.mBeanServer.getAttribute(new ObjectName("kafka.consumer:type=app-info,client-id=" + tag.getValue()), "version");
                    return Integer.parseInt(string.substring(0, string.indexOf(46)));
                }
                catch (Throwable throwable) {
                    Throwables.throwIfCritical(throwable);
                    Throwable throwable2 = throwable;
                    return -1;
                }
            }).orElse(-1);
        }
        return this.kafkaMajorVersion;
    }

    private void registerMetricsEventually(MeterRegistry meterRegistry, String string, BiFunction<ObjectName, Tags, List<Meter>> biFunction) {
        try {
            Set<ObjectName> set = this.mBeanServer.queryNames(new ObjectName("kafka.consumer:type=" + string + ",*"), null);
            if (!set.isEmpty()) {
                for (ObjectName objectName : set) {
                    List<Meter> list = biFunction.apply(objectName, Tags.concat(this.tags, this.nameTag(objectName)));
                    this.addUnregistrationListener(meterRegistry, string, objectName, list);
                }
                return;
            }
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new RuntimeException("Error registering Kafka JMX based metrics", malformedObjectNameException);
        }
        this.registerNotificationListener(meterRegistry, string, biFunction);
    }

    private void registerNotificationListener(MeterRegistry meterRegistry, String string, BiFunction<ObjectName, Tags, List<Meter>> biFunction) {
        NotificationListener notificationListener = (notification, object) -> {
            MBeanServerNotification mBeanServerNotification = (MBeanServerNotification)notification;
            ObjectName objectName = mBeanServerNotification.getMBeanName();
            List list = (List)biFunction.apply(objectName, Tags.concat(this.tags, this.nameTag(objectName)));
            this.addUnregistrationListener(meterRegistry, string, objectName, list);
        };
        NotificationFilter notificationFilter = this.createNotificationFilter(string, "JMX.mbean.registered");
        this.addNotificationListener(notificationListener, notificationFilter);
        this.notificationListenerCleanUpRunnables.add(() -> this.removeNotificationListener(notificationListener));
    }

    private void removeNotificationListener(NotificationListener notificationListener) {
        try {
            this.mBeanServer.removeNotificationListener(MBeanServerDelegate.DELEGATE_NAME, notificationListener);
        }
        catch (InstanceNotFoundException | ListenerNotFoundException operationsException) {
            // empty catch block
        }
    }

    private void addUnregistrationListener(final MeterRegistry meterRegistry, String string, final ObjectName objectName, final List<Meter> list) {
        NotificationListener notificationListener = new NotificationListener(){

            @Override
            public void handleNotification(Notification notification, Object object) {
                MBeanServerNotification mBeanServerNotification = (MBeanServerNotification)notification;
                ObjectName objectName2 = mBeanServerNotification.getMBeanName();
                if (objectName2.equals(objectName)) {
                    list.stream().forEach(meterRegistry::remove);
                }
                KafkaConsumerMetrics.this.removeNotificationListener(this);
            }
        };
        NotificationFilter notificationFilter = this.createNotificationFilter(string, "JMX.mbean.unregistered");
        this.addNotificationListener(notificationListener, notificationFilter);
    }

    private NotificationFilter createNotificationFilter(String string, String string2) {
        return notification -> {
            if (!string2.equals(notification.getType())) {
                return false;
            }
            ObjectName objectName = ((MBeanServerNotification)notification).getMBeanName();
            return objectName.getDomain().equals(JMX_DOMAIN) && objectName.getKeyProperty("type").equals(string);
        };
    }

    private void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter) {
        try {
            this.mBeanServer.addNotificationListener(MBeanServerDelegate.DELEGATE_NAME, notificationListener, notificationFilter, null);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new RuntimeException("Error registering Kafka MBean listener", instanceNotFoundException);
        }
    }

    private double safeDouble(Callable<Object> callable) {
        try {
            return Double.parseDouble(callable.call().toString());
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            return Double.NaN;
        }
    }

    private Iterable<Tag> nameTag(ObjectName objectName) {
        String string;
        String string2;
        Tags tags = Tags.empty();
        String string3 = objectName.getKeyProperty("client-id");
        if (string3 != null) {
            tags = Tags.concat((Iterable<? extends Tag>)tags, "client.id", string3);
        }
        if ((string2 = objectName.getKeyProperty("topic")) != null) {
            tags = Tags.concat((Iterable<? extends Tag>)tags, "topic", string2);
        }
        if ((string = objectName.getKeyProperty("partition")) != null) {
            tags = Tags.concat((Iterable<? extends Tag>)tags, "partition", string);
        }
        return tags;
    }

    private static String sanitize(String string) {
        return string.replaceAll("-", ".");
    }

    @Override
    public void close() {
        this.notificationListenerCleanUpRunnables.forEach(Runnable::run);
    }
}

