/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.instrument.binder.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.LoggerContextListener;
import ch.qos.logback.classic.turbo.TurboFilter;
import com.contrastsecurity.thirdparty.imm.common.lang.NonNullApi;
import com.contrastsecurity.thirdparty.imm.common.lang.NonNullFields;
import com.contrastsecurity.thirdparty.imm.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.imm.core.instrument.Tag;
import com.contrastsecurity.thirdparty.imm.core.instrument.binder.MeterBinder;
import com.contrastsecurity.thirdparty.imm.core.instrument.binder.logging.MetricsTurboFilter;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@NonNullApi
@NonNullFields
public class LogbackMetrics
implements MeterBinder,
AutoCloseable {
    static ThreadLocal<Boolean> ignoreMetrics = new ThreadLocal();
    private final Iterable<Tag> tags;
    private final LoggerContext loggerContext;
    private final Map<MeterRegistry, MetricsTurboFilter> metricsTurboFilters = new HashMap<MeterRegistry, MetricsTurboFilter>();

    public LogbackMetrics() {
        this(Collections.emptyList());
    }

    public LogbackMetrics(Iterable<Tag> iterable) {
        this(iterable, (LoggerContext)LoggerFactory.getILoggerFactory());
    }

    public LogbackMetrics(Iterable<Tag> iterable, LoggerContext loggerContext) {
        this.tags = iterable;
        this.loggerContext = loggerContext;
        this.loggerContext.addListener(new LoggerContextListener(){

            public boolean isResetResistant() {
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onReset(LoggerContext loggerContext) {
                Map map = LogbackMetrics.this.metricsTurboFilters;
                synchronized (map) {
                    for (MetricsTurboFilter metricsTurboFilter : LogbackMetrics.this.metricsTurboFilters.values()) {
                        LogbackMetrics.this.loggerContext.addTurboFilter((TurboFilter)metricsTurboFilter);
                    }
                }
            }

            public void onStart(LoggerContext loggerContext) {
            }

            public void onStop(LoggerContext loggerContext) {
            }

            public void onLevelChange(Logger logger, Level level) {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bindTo(MeterRegistry meterRegistry) {
        MetricsTurboFilter metricsTurboFilter = new MetricsTurboFilter(meterRegistry, this.tags);
        Map<MeterRegistry, MetricsTurboFilter> map = this.metricsTurboFilters;
        synchronized (map) {
            this.metricsTurboFilters.put(meterRegistry, metricsTurboFilter);
            this.loggerContext.addTurboFilter((TurboFilter)metricsTurboFilter);
        }
    }

    public static void ignoreMetrics(Runnable runnable) {
        ignoreMetrics.set(true);
        try {
            runnable.run();
        }
        finally {
            ignoreMetrics.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Map<MeterRegistry, MetricsTurboFilter> map = this.metricsTurboFilters;
        synchronized (map) {
            for (MetricsTurboFilter metricsTurboFilter : this.metricsTurboFilters.values()) {
                this.loggerContext.getTurboFilterList().remove((Object)metricsTurboFilter);
            }
        }
    }

    static {
        LoggerFactory.getILoggerFactory();
    }
}

