/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.instrument.binder.okhttp3;

import com.contrastsecurity.thirdparty.imm.common.lang.NonNullApi;
import com.contrastsecurity.thirdparty.imm.common.lang.NonNullFields;
import com.contrastsecurity.thirdparty.imm.common.lang.Nullable;
import com.contrastsecurity.thirdparty.imm.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.imm.core.instrument.Tag;
import com.contrastsecurity.thirdparty.imm.core.instrument.Tags;
import com.contrastsecurity.thirdparty.imm.core.instrument.Timer;
import com.contrastsecurity.thirdparty.imm.core.instrument.binder.http.Outcome;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import okhttp3.Call;
import okhttp3.EventListener;
import okhttp3.Request;
import okhttp3.Response;

@NonNullApi
@NonNullFields
public class OkHttpMetricsEventListener
extends EventListener {
    public static final String URI_PATTERN = "URI_PATTERN";
    private static final boolean REQUEST_TAG_CLASS_EXISTS = OkHttpMetricsEventListener.getMethod(Class.class) != null;
    private static final String TAG_TARGET_SCHEME = "target.scheme";
    private static final String TAG_TARGET_HOST = "target.host";
    private static final String TAG_TARGET_PORT = "target.port";
    private static final String TAG_VALUE_UNKNOWN = "UNKNOWN";
    private static final Tags TAGS_TARGET_UNKNOWN = Tags.of("target.scheme", "UNKNOWN", "target.host", "UNKNOWN", "target.port", "UNKNOWN");
    private final MeterRegistry registry;
    private final String requestsMetricName;
    private final Function<Request, String> urlMapper;
    private final Iterable<Tag> extraTags;
    private final Iterable<BiFunction<Request, Response, Tag>> contextSpecificTags;
    private final Iterable<Tag> unknownRequestTags;
    private final boolean includeHostTag;
    final ConcurrentMap<Call, CallState> callState = new ConcurrentHashMap<Call, CallState>();

    @Nullable
    private static Method getMethod(Class<?> ... classArray) {
        try {
            return Request.class.getMethod("tag", classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    protected OkHttpMetricsEventListener(MeterRegistry meterRegistry, String string, Function<Request, String> function, Iterable<Tag> iterable, Iterable<BiFunction<Request, Response, Tag>> iterable2) {
        this(meterRegistry, string, function, iterable, iterable2, Collections.emptyList(), true);
    }

    OkHttpMetricsEventListener(MeterRegistry meterRegistry, String string, Function<Request, String> function, Iterable<Tag> iterable, Iterable<BiFunction<Request, Response, Tag>> iterable2, Iterable<String> iterable3, boolean bl2) {
        this.registry = meterRegistry;
        this.requestsMetricName = string;
        this.urlMapper = function;
        this.extraTags = iterable;
        this.contextSpecificTags = iterable2;
        this.includeHostTag = bl2;
        ArrayList<Tag> arrayList = new ArrayList<Tag>();
        for (String string2 : iterable3) {
            arrayList.add(Tag.of(string2, TAG_VALUE_UNKNOWN));
        }
        this.unknownRequestTags = arrayList;
    }

    public static Builder builder(MeterRegistry meterRegistry, String string) {
        return new Builder(meterRegistry, string);
    }

    public void callStart(Call call) {
        this.callState.put(call, new CallState(this.registry.config().clock().monotonicTime(), call.request()));
    }

    public void callFailed(Call call, IOException iOException) {
        CallState callState = (CallState)this.callState.remove(call);
        if (callState != null) {
            callState.exception = iOException;
            this.time(callState);
        }
    }

    public void callEnd(Call call) {
        this.callState.remove(call);
    }

    public void responseHeadersEnd(Call call, Response response) {
        CallState callState = (CallState)this.callState.remove(call);
        if (callState != null) {
            callState.response = response;
            this.time(callState);
        }
    }

    void time(CallState callState) {
        Request request = callState.request;
        boolean bl2 = request != null;
        Tags tags = Tags.of("method", bl2 ? request.method() : TAG_VALUE_UNKNOWN, "uri", this.getUriTag(callState, request), "status", this.getStatusMessage(callState.response, callState.exception)).and(this.getStatusOutcome(callState.response).asTag()).and(this.extraTags).and(StreamSupport.stream(this.contextSpecificTags.spliterator(), false).map(biFunction -> (Tag)biFunction.apply(request, callState.response)).collect(Collectors.toList())).and(this.getRequestTags(request)).and(this.generateTagsForRoute(request));
        if (this.includeHostTag) {
            tags = Tags.of(tags).and("host", bl2 ? request.url().host() : TAG_VALUE_UNKNOWN);
        }
        ((Timer.Builder)Timer.builder(this.requestsMetricName).tags((Iterable)tags)).description("Timer of OkHttp operation").register(this.registry).record(this.registry.config().clock().monotonicTime() - callState.startTime, TimeUnit.NANOSECONDS);
    }

    private Tags generateTagsForRoute(@Nullable Request request) {
        if (request == null) {
            return TAGS_TARGET_UNKNOWN;
        }
        return Tags.of(TAG_TARGET_SCHEME, request.url().scheme(), TAG_TARGET_HOST, request.url().host(), TAG_TARGET_PORT, Integer.toString(request.url().port()));
    }

    private String getUriTag(CallState callState, @Nullable Request request) {
        if (request == null) {
            return TAG_VALUE_UNKNOWN;
        }
        return callState.response != null && (callState.response.code() == 404 || callState.response.code() == 301) ? "NOT_FOUND" : this.urlMapper.apply(request);
    }

    private Iterable<Tag> getRequestTags(@Nullable Request request) {
        Object object;
        if (request == null) {
            return this.unknownRequestTags;
        }
        if (REQUEST_TAG_CLASS_EXISTS && (object = (Tags)request.tag(Tags.class)) != null) {
            return object;
        }
        object = request.tag();
        if (object instanceof Tags) {
            return (Tags)object;
        }
        return Tags.empty();
    }

    private Outcome getStatusOutcome(@Nullable Response response) {
        if (response == null) {
            return Outcome.UNKNOWN;
        }
        return Outcome.forStatus(response.code());
    }

    private String getStatusMessage(@Nullable Response response, @Nullable IOException iOException) {
        if (iOException != null) {
            return "IO_ERROR";
        }
        if (response == null) {
            return "CLIENT_ERROR";
        }
        return Integer.toString(response.code());
    }

    public static class Builder {
        private final MeterRegistry registry;
        private final String name;
        private Function<Request, String> uriMapper = request -> Optional.ofNullable(request.header(OkHttpMetricsEventListener.URI_PATTERN)).orElse("none");
        private Tags tags = Tags.empty();
        private Collection<BiFunction<Request, Response, Tag>> contextSpecificTags = new ArrayList<BiFunction<Request, Response, Tag>>();
        private boolean includeHostTag = true;
        private Iterable<String> requestTagKeys = Collections.emptyList();

        Builder(MeterRegistry meterRegistry, String string) {
            this.registry = meterRegistry;
            this.name = string;
        }

        public Builder tags(Iterable<Tag> iterable) {
            this.tags = this.tags.and(iterable);
            return this;
        }

        public Builder tag(Tag tag) {
            this.tags = this.tags.and(tag);
            return this;
        }

        public Builder tag(BiFunction<Request, Response, Tag> biFunction) {
            this.contextSpecificTags.add(biFunction);
            return this;
        }

        public Builder uriMapper(Function<Request, String> function) {
            this.uriMapper = function;
            return this;
        }

        public Builder includeHostTag(boolean bl2) {
            this.includeHostTag = bl2;
            return this;
        }

        public Builder requestTagKeys(String ... stringArray) {
            return this.requestTagKeys(Arrays.asList(stringArray));
        }

        public Builder requestTagKeys(Iterable<String> iterable) {
            this.requestTagKeys = iterable;
            return this;
        }

        public OkHttpMetricsEventListener build() {
            return new OkHttpMetricsEventListener(this.registry, this.name, this.uriMapper, this.tags, this.contextSpecificTags, this.requestTagKeys, this.includeHostTag);
        }
    }

    static class CallState {
        final long startTime;
        @Nullable
        final Request request;
        @Nullable
        Response response;
        @Nullable
        IOException exception;

        CallState(long l2, @Nullable Request request) {
            this.startTime = l2;
            this.request = request;
        }
    }
}

