/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.instrument.binder.system;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.imm.common.lang.NonNullApi;
import com.contrastsecurity.thirdparty.imm.common.lang.NonNullFields;
import com.contrastsecurity.thirdparty.imm.common.lang.Nullable;
import com.contrastsecurity.thirdparty.imm.core.instrument.Gauge;
import com.contrastsecurity.thirdparty.imm.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.imm.core.instrument.Tag;
import com.contrastsecurity.thirdparty.imm.core.instrument.binder.MeterBinder;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@NonNullApi
@NonNullFields
public class ProcessorMetrics
implements MeterBinder {
    private static final List<String> OPERATING_SYSTEM_BEAN_CLASS_NAMES = Arrays.asList("com.ibm.lang.management.OperatingSystemMXBean", "com.sun.management.OperatingSystemMXBean");
    private final Iterable<Tag> tags;
    private final OperatingSystemMXBean operatingSystemBean;
    @Nullable
    private final Class<?> operatingSystemBeanClass;
    @Nullable
    private final Method systemCpuUsage;
    @Nullable
    private final Method processCpuUsage;

    public ProcessorMetrics() {
        this(Collections.emptyList());
    }

    public ProcessorMetrics(Iterable<Tag> iterable) {
        this.tags = iterable;
        this.operatingSystemBean = ManagementFactory.getOperatingSystemMXBean();
        this.operatingSystemBeanClass = this.getFirstClassFound(OPERATING_SYSTEM_BEAN_CLASS_NAMES);
        Method method = this.detectMethod("getCpuLoad");
        this.systemCpuUsage = method != null ? method : this.detectMethod("getSystemCpuLoad");
        this.processCpuUsage = this.detectMethod("getProcessCpuLoad");
    }

    @Override
    public void bindTo(MeterRegistry meterRegistry) {
        Runtime runtime = Runtime.getRuntime();
        Gauge.builder("system.cpu.count", runtime, Runtime::availableProcessors).tags(this.tags).description("The number of processors available to the Java virtual machine").register(meterRegistry);
        if (this.operatingSystemBean.getSystemLoadAverage() >= 0.0) {
            Gauge.builder("system.load.average.1m", this.operatingSystemBean, OperatingSystemMXBean::getSystemLoadAverage).tags(this.tags).description("The sum of the number of runnable entities queued to available processors and the number of runnable entities running on the available processors averaged over a period of time").register(meterRegistry);
        }
        if (this.systemCpuUsage != null) {
            Gauge.builder("system.cpu.usage", this.operatingSystemBean, operatingSystemMXBean -> this.invoke(this.systemCpuUsage)).tags(this.tags).description("The \"recent cpu usage\" of the system the application is running in").register(meterRegistry);
        }
        if (this.processCpuUsage != null) {
            Gauge.builder("process.cpu.usage", this.operatingSystemBean, operatingSystemMXBean -> this.invoke(this.processCpuUsage)).tags(this.tags).description("The \"recent cpu usage\" for the Java Virtual Machine process").register(meterRegistry);
        }
    }

    private double invoke(@Nullable Method method) {
        try {
            return method != null ? (Double)method.invoke((Object)this.operatingSystemBean, new Object[0]) : Double.NaN;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            return Double.NaN;
        }
    }

    @Nullable
    private Method detectMethod(String string) {
        Objects.requireNonNull(string);
        if (this.operatingSystemBeanClass == null) {
            return null;
        }
        try {
            this.operatingSystemBeanClass.cast(this.operatingSystemBean);
            return this.operatingSystemBeanClass.getMethod(string, new Class[0]);
        }
        catch (ClassCastException | NoSuchMethodException | SecurityException exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            return null;
        }
    }

    @Nullable
    private Class<?> getFirstClassFound(List<String> list) {
        for (String string : list) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }
}

