/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.instrument.composite;

import com.contrastsecurity.thirdparty.imm.core.instrument.FunctionCounter;
import com.contrastsecurity.thirdparty.imm.core.instrument.Meter;
import com.contrastsecurity.thirdparty.imm.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.imm.core.instrument.composite.AbstractCompositeMeter;
import com.contrastsecurity.thirdparty.imm.core.instrument.noop.NoopFunctionCounter;
import java.lang.ref.WeakReference;
import java.util.function.ToDoubleFunction;

public class CompositeFunctionCounter<T>
extends AbstractCompositeMeter<FunctionCounter>
implements FunctionCounter {
    private final WeakReference<T> ref;
    private final ToDoubleFunction<T> f;

    CompositeFunctionCounter(Meter.Id id, T t2, ToDoubleFunction<T> toDoubleFunction) {
        super(id);
        this.ref = new WeakReference<T>(t2);
        this.f = toDoubleFunction;
    }

    @Override
    public double count() {
        Object t2 = this.ref.get();
        return t2 != null ? this.f.applyAsDouble(t2) : 0.0;
    }

    @Override
    FunctionCounter newNoopMeter() {
        return new NoopFunctionCounter(this.getId());
    }

    @Override
    FunctionCounter registerNewMeter(MeterRegistry meterRegistry) {
        Object t2 = this.ref.get();
        if (t2 == null) {
            return null;
        }
        return FunctionCounter.builder(this.getId().getName(), t2, this.f).tags(this.getId().getTagsAsIterable()).description(this.getId().getDescription()).baseUnit(this.getId().getBaseUnit()).register(meterRegistry);
    }
}

