/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.instrument.composite;

import com.contrastsecurity.thirdparty.imm.common.lang.Nullable;
import com.contrastsecurity.thirdparty.imm.core.instrument.Clock;
import com.contrastsecurity.thirdparty.imm.core.instrument.Counter;
import com.contrastsecurity.thirdparty.imm.core.instrument.DistributionSummary;
import com.contrastsecurity.thirdparty.imm.core.instrument.FunctionCounter;
import com.contrastsecurity.thirdparty.imm.core.instrument.FunctionTimer;
import com.contrastsecurity.thirdparty.imm.core.instrument.Gauge;
import com.contrastsecurity.thirdparty.imm.core.instrument.LongTaskTimer;
import com.contrastsecurity.thirdparty.imm.core.instrument.Measurement;
import com.contrastsecurity.thirdparty.imm.core.instrument.Meter;
import com.contrastsecurity.thirdparty.imm.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.imm.core.instrument.TimeGauge;
import com.contrastsecurity.thirdparty.imm.core.instrument.Timer;
import com.contrastsecurity.thirdparty.imm.core.instrument.composite.CompositeCounter;
import com.contrastsecurity.thirdparty.imm.core.instrument.composite.CompositeCustomMeter;
import com.contrastsecurity.thirdparty.imm.core.instrument.composite.CompositeDistributionSummary;
import com.contrastsecurity.thirdparty.imm.core.instrument.composite.CompositeFunctionCounter;
import com.contrastsecurity.thirdparty.imm.core.instrument.composite.CompositeFunctionTimer;
import com.contrastsecurity.thirdparty.imm.core.instrument.composite.CompositeGauge;
import com.contrastsecurity.thirdparty.imm.core.instrument.composite.CompositeLongTaskTimer;
import com.contrastsecurity.thirdparty.imm.core.instrument.composite.CompositeMeter;
import com.contrastsecurity.thirdparty.imm.core.instrument.composite.CompositeTimeGauge;
import com.contrastsecurity.thirdparty.imm.core.instrument.composite.CompositeTimer;
import com.contrastsecurity.thirdparty.imm.core.instrument.config.NamingConvention;
import com.contrastsecurity.thirdparty.imm.core.instrument.distribution.DistributionStatisticConfig;
import com.contrastsecurity.thirdparty.imm.core.instrument.distribution.pause.PauseDetector;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;

public class CompositeMeterRegistry
extends MeterRegistry {
    private final AtomicBoolean registriesLock = new AtomicBoolean();
    private final Set<MeterRegistry> registries = Collections.newSetFromMap(new IdentityHashMap());
    private final Set<MeterRegistry> unmodifiableRegistries = Collections.unmodifiableSet(this.registries);
    volatile Set<MeterRegistry> nonCompositeDescendants = Collections.emptySet();
    private final AtomicBoolean parentLock = new AtomicBoolean();
    private volatile Set<CompositeMeterRegistry> parents = Collections.newSetFromMap(new IdentityHashMap());

    public CompositeMeterRegistry() {
        this(Clock.SYSTEM);
    }

    public CompositeMeterRegistry(Clock clock) {
        this(clock, Collections.emptySet());
    }

    public CompositeMeterRegistry(Clock clock, Iterable<MeterRegistry> iterable) {
        super(clock);
        this.config().namingConvention(NamingConvention.identity).onMeterAdded(meter -> {
            if (meter instanceof CompositeMeter) {
                this.lock(this.registriesLock, () -> this.nonCompositeDescendants.forEach(((CompositeMeter)meter)::add));
            }
        }).onMeterRemoved(meter -> {
            if (meter instanceof CompositeMeter) {
                this.lock(this.registriesLock, () -> this.nonCompositeDescendants.forEach(meterRegistry -> meterRegistry.removeByPreFilterId(meter.getId())));
            }
        });
        iterable.forEach(this::add);
    }

    @Override
    protected Timer newTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector) {
        return new CompositeTimer(id, this.clock, distributionStatisticConfig, pauseDetector);
    }

    @Override
    protected DistributionSummary newDistributionSummary(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, double d2) {
        return new CompositeDistributionSummary(id, distributionStatisticConfig, d2);
    }

    @Override
    protected Counter newCounter(Meter.Id id) {
        return new CompositeCounter(id);
    }

    @Override
    protected LongTaskTimer newLongTaskTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig) {
        return new CompositeLongTaskTimer(id, distributionStatisticConfig);
    }

    @Override
    protected <T> Gauge newGauge(Meter.Id id, @Nullable T t2, ToDoubleFunction<T> toDoubleFunction) {
        return new CompositeGauge<T>(id, t2, toDoubleFunction);
    }

    @Override
    protected <T> TimeGauge newTimeGauge(Meter.Id id, @Nullable T t2, TimeUnit timeUnit, ToDoubleFunction<T> toDoubleFunction) {
        return new CompositeTimeGauge<T>(id, t2, timeUnit, toDoubleFunction);
    }

    @Override
    protected <T> FunctionTimer newFunctionTimer(Meter.Id id, T t2, ToLongFunction<T> toLongFunction, ToDoubleFunction<T> toDoubleFunction, TimeUnit timeUnit) {
        return new CompositeFunctionTimer<T>(id, t2, toLongFunction, toDoubleFunction, timeUnit);
    }

    @Override
    protected <T> FunctionCounter newFunctionCounter(Meter.Id id, T t2, ToDoubleFunction<T> toDoubleFunction) {
        return new CompositeFunctionCounter<T>(id, t2, toDoubleFunction);
    }

    @Override
    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.SECONDS;
    }

    @Override
    protected DistributionStatisticConfig defaultHistogramConfig() {
        return DistributionStatisticConfig.NONE;
    }

    @Override
    protected Meter newMeter(Meter.Id id, Meter.Type type, Iterable<Measurement> iterable) {
        return new CompositeCustomMeter(id, type, iterable);
    }

    public CompositeMeterRegistry add(MeterRegistry meterRegistry) {
        this.lock(this.registriesLock, () -> {
            this.forbidSelfContainingComposite(meterRegistry);
            if (meterRegistry instanceof CompositeMeterRegistry) {
                ((CompositeMeterRegistry)meterRegistry).addParent(this);
            }
            if (this.registries.add(meterRegistry)) {
                this.updateDescendants();
            }
        });
        return this;
    }

    private void forbidSelfContainingComposite(MeterRegistry meterRegistry) {
        if (meterRegistry == this) {
            throw new IllegalArgumentException("Adding a composite meter registry to itself is not allowed!");
        }
        if (meterRegistry instanceof CompositeMeterRegistry) {
            ((CompositeMeterRegistry)meterRegistry).getRegistries().forEach(this::forbidSelfContainingComposite);
        }
    }

    public CompositeMeterRegistry remove(MeterRegistry meterRegistry) {
        this.lock(this.registriesLock, () -> {
            if (meterRegistry instanceof CompositeMeterRegistry) {
                ((CompositeMeterRegistry)meterRegistry).removeParent(this);
            }
            if (this.registries.remove(meterRegistry)) {
                this.updateDescendants();
            }
        });
        return this;
    }

    private void removeParent(CompositeMeterRegistry compositeMeterRegistry) {
        this.lock(this.parentLock, () -> this.parents.remove(compositeMeterRegistry));
    }

    private void addParent(CompositeMeterRegistry compositeMeterRegistry) {
        this.lock(this.parentLock, () -> this.parents.add(compositeMeterRegistry));
    }

    private void lock(AtomicBoolean atomicBoolean, Runnable runnable) {
        while (!atomicBoolean.compareAndSet(false, true)) {
        }
        try {
            runnable.run();
        }
        finally {
            atomicBoolean.set(false);
        }
    }

    private void updateDescendants() {
        Set set = Collections.newSetFromMap(new IdentityHashMap());
        for (MeterRegistry object2 : this.registries) {
            if (object2 instanceof CompositeMeterRegistry) {
                set.addAll(((CompositeMeterRegistry)object2).nonCompositeDescendants);
                continue;
            }
            set.add(object2);
        }
        Set set2 = Collections.newSetFromMap(new IdentityHashMap());
        set2.addAll(this.nonCompositeDescendants);
        set2.removeAll(set);
        Set set3 = Collections.newSetFromMap(new IdentityHashMap());
        set3.addAll(set);
        set3.removeAll(this.nonCompositeDescendants);
        if (!set2.isEmpty() || !set3.isEmpty()) {
            for (Meter meter : this.getMeters()) {
                if (!(meter instanceof CompositeMeter)) continue;
                CompositeMeter compositeMeter = (CompositeMeter)meter;
                set2.forEach(compositeMeter::remove);
                set3.forEach(compositeMeter::add);
            }
        }
        this.nonCompositeDescendants = set;
        this.lock(this.parentLock, () -> this.parents.forEach(CompositeMeterRegistry::updateDescendants));
    }

    public Set<MeterRegistry> getRegistries() {
        return this.unmodifiableRegistries;
    }

    @Override
    public void close() {
        this.registries.forEach(MeterRegistry::close);
        super.close();
    }
}

