/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.instrument.distribution;

import com.contrastsecurity.thirdparty.imm.common.lang.Nullable;
import com.contrastsecurity.thirdparty.imm.core.instrument.config.InvalidConfigurationException;
import com.contrastsecurity.thirdparty.imm.core.instrument.distribution.PercentileHistogramBuckets;
import com.contrastsecurity.thirdparty.imm.core.instrument.internal.Mergeable;
import java.time.Duration;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.stream.LongStream;

public class DistributionStatisticConfig
implements Mergeable<DistributionStatisticConfig> {
    public static final DistributionStatisticConfig DEFAULT = DistributionStatisticConfig.builder().percentilesHistogram(false).percentilePrecision(1).minimumExpectedValue(1.0).maximumExpectedValue(Double.POSITIVE_INFINITY).expiry(Duration.ofMinutes(2L)).bufferLength(3).build();
    public static final DistributionStatisticConfig NONE = DistributionStatisticConfig.builder().build();
    @Nullable
    private Boolean percentileHistogram;
    @Nullable
    private double[] percentiles;
    @Nullable
    private Integer percentilePrecision;
    @Nullable
    private double[] serviceLevelObjectives;
    @Nullable
    private Double minimumExpectedValue;
    @Nullable
    private Double maximumExpectedValue;
    @Nullable
    private Duration expiry;
    @Nullable
    private Integer bufferLength;

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public DistributionStatisticConfig merge(DistributionStatisticConfig distributionStatisticConfig) {
        return DistributionStatisticConfig.builder().percentilesHistogram(this.percentileHistogram == null ? distributionStatisticConfig.percentileHistogram : this.percentileHistogram).percentiles(this.percentiles == null ? distributionStatisticConfig.percentiles : this.percentiles).serviceLevelObjectives(this.serviceLevelObjectives == null ? distributionStatisticConfig.serviceLevelObjectives : this.serviceLevelObjectives).percentilePrecision(this.percentilePrecision == null ? distributionStatisticConfig.percentilePrecision : this.percentilePrecision).minimumExpectedValue(this.minimumExpectedValue == null ? distributionStatisticConfig.minimumExpectedValue : this.minimumExpectedValue).maximumExpectedValue(this.maximumExpectedValue == null ? distributionStatisticConfig.maximumExpectedValue : this.maximumExpectedValue).expiry(this.expiry == null ? distributionStatisticConfig.expiry : this.expiry).bufferLength(this.bufferLength == null ? distributionStatisticConfig.bufferLength : this.bufferLength).build();
    }

    public NavigableSet<Double> getHistogramBuckets(boolean bl2) {
        TreeSet<Double> treeSet = new TreeSet<Double>();
        if (this.percentileHistogram != null && this.percentileHistogram.booleanValue() && bl2) {
            treeSet.addAll(PercentileHistogramBuckets.buckets(this));
            treeSet.add(this.minimumExpectedValue);
            treeSet.add(this.maximumExpectedValue);
        }
        if (this.serviceLevelObjectives != null) {
            for (double d2 : this.serviceLevelObjectives) {
                treeSet.add(d2);
            }
        }
        return treeSet;
    }

    @Nullable
    public Boolean isPercentileHistogram() {
        return this.percentileHistogram;
    }

    @Nullable
    public double[] getPercentiles() {
        return this.percentiles;
    }

    @Nullable
    public Integer getPercentilePrecision() {
        return this.percentilePrecision;
    }

    @Deprecated
    @Nullable
    public Double getMinimumExpectedValue() {
        return this.getMinimumExpectedValueAsDouble();
    }

    @Nullable
    public Double getMinimumExpectedValueAsDouble() {
        return this.minimumExpectedValue;
    }

    @Deprecated
    @Nullable
    public Double getMaximumExpectedValue() {
        return this.getMaximumExpectedValueAsDouble();
    }

    @Nullable
    public Double getMaximumExpectedValueAsDouble() {
        return this.maximumExpectedValue;
    }

    @Nullable
    public Duration getExpiry() {
        return this.expiry;
    }

    @Nullable
    public Integer getBufferLength() {
        return this.bufferLength;
    }

    @Nullable
    @Deprecated
    public double[] getSlaBoundaries() {
        return this.getServiceLevelObjectiveBoundaries();
    }

    @Nullable
    public double[] getServiceLevelObjectiveBoundaries() {
        return this.serviceLevelObjectives;
    }

    public boolean isPublishingPercentiles() {
        return this.percentiles != null && this.percentiles.length > 0;
    }

    public boolean isPublishingHistogram() {
        return this.percentileHistogram != null && this.percentileHistogram != false || this.serviceLevelObjectives != null && this.serviceLevelObjectives.length > 0;
    }

    static /* synthetic */ double[] access$102(DistributionStatisticConfig distributionStatisticConfig, double[] dArray) {
        distributionStatisticConfig.percentiles = dArray;
        return dArray;
    }

    static /* synthetic */ double[] access$302(DistributionStatisticConfig distributionStatisticConfig, double[] dArray) {
        distributionStatisticConfig.serviceLevelObjectives = dArray;
        return dArray;
    }

    public static class Builder {
        private final DistributionStatisticConfig config = new DistributionStatisticConfig();

        public Builder percentilesHistogram(@Nullable Boolean bl2) {
            this.config.percentileHistogram = bl2;
            return this;
        }

        public Builder percentiles(double ... dArray) {
            DistributionStatisticConfig.access$102(this.config, dArray);
            return this;
        }

        public Builder percentilePrecision(@Nullable Integer n2) {
            this.config.percentilePrecision = n2;
            return this;
        }

        public Builder serviceLevelObjectives(double ... dArray) {
            DistributionStatisticConfig.access$302(this.config, dArray);
            return this;
        }

        @Deprecated
        public Builder sla(double ... dArray) {
            return this.serviceLevelObjectives(dArray);
        }

        @Deprecated
        public Builder sla(long ... lArray) {
            return lArray == null ? this : this.serviceLevelObjectives(LongStream.of(lArray).asDoubleStream().toArray());
        }

        @Deprecated
        public Builder minimumExpectedValue(@Nullable Long l2) {
            return l2 == null ? this : this.minimumExpectedValue((double)l2);
        }

        public Builder minimumExpectedValue(@Nullable Double d2) {
            this.config.minimumExpectedValue = d2;
            return this;
        }

        @Deprecated
        public Builder maximumExpectedValue(@Nullable Long l2) {
            return l2 == null ? this : this.maximumExpectedValue((double)l2);
        }

        public Builder maximumExpectedValue(@Nullable Double d2) {
            this.config.maximumExpectedValue = d2;
            return this;
        }

        public Builder expiry(@Nullable Duration duration) {
            this.config.expiry = duration;
            return this;
        }

        public Builder bufferLength(@Nullable Integer n2) {
            this.config.bufferLength = n2;
            return this;
        }

        public DistributionStatisticConfig build() {
            this.validate(this.config);
            return this.config;
        }

        private void validate(DistributionStatisticConfig distributionStatisticConfig) {
            if (this.config.bufferLength != null && this.config.bufferLength <= 0) {
                Builder.rejectConfig("bufferLength (" + this.config.bufferLength + ") must be greater than zero");
            }
            if (this.config.percentiles != null) {
                for (double d2 : this.config.percentiles) {
                    if (!(d2 < 0.0) && !(d2 > 1.0)) continue;
                    Builder.rejectConfig("percentiles must contain only the values between 0.0 and 1.0. Found " + d2);
                }
            }
            if (this.config.minimumExpectedValue != null && this.config.minimumExpectedValue <= 0.0) {
                Builder.rejectConfig("minimumExpectedValue (" + this.config.minimumExpectedValue + ") must be greater than 0.");
            }
            if (this.config.maximumExpectedValue != null && this.config.maximumExpectedValue <= 0.0) {
                Builder.rejectConfig("maximumExpectedValue (" + this.config.minimumExpectedValue + ") must be greater than 0.");
            }
            if (this.config.minimumExpectedValue != null && this.config.maximumExpectedValue != null && this.config.minimumExpectedValue > this.config.maximumExpectedValue) {
                Builder.rejectConfig("maximumExpectedValue (" + this.config.maximumExpectedValue + ") must be equal to or greater than minimumExpectedValue (" + this.config.minimumExpectedValue + ").");
            }
            if (distributionStatisticConfig.getServiceLevelObjectiveBoundaries() != null) {
                for (double d2 : distributionStatisticConfig.getServiceLevelObjectiveBoundaries()) {
                    if (!(d2 <= 0.0)) continue;
                    Builder.rejectConfig("serviceLevelObjectiveBoundaries must contain only the values greater than 0. Found " + d2);
                }
            }
        }

        private static void rejectConfig(String string) {
            throw new InvalidConfigurationException("Invalid distribution configuration: " + string);
        }
    }
}

