/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.instrument.internal;

import com.contrastsecurity.thirdparty.imm.core.instrument.AbstractMeter;
import com.contrastsecurity.thirdparty.imm.core.instrument.Clock;
import com.contrastsecurity.thirdparty.imm.core.instrument.LongTaskTimer;
import com.contrastsecurity.thirdparty.imm.core.instrument.Meter;
import com.contrastsecurity.thirdparty.imm.core.instrument.distribution.CountAtBucket;
import com.contrastsecurity.thirdparty.imm.core.instrument.distribution.DistributionStatisticConfig;
import com.contrastsecurity.thirdparty.imm.core.instrument.distribution.HistogramSnapshot;
import com.contrastsecurity.thirdparty.imm.core.instrument.distribution.ValueAtPercentile;
import com.contrastsecurity.thirdparty.imm.core.instrument.util.TimeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class DefaultLongTaskTimer
extends AbstractMeter
implements LongTaskTimer {
    private final Deque<SampleImpl> activeTasks = new ConcurrentLinkedDeque<SampleImpl>();
    private final Clock clock;
    private final TimeUnit baseTimeUnit;
    private final DistributionStatisticConfig distributionStatisticConfig;
    private final boolean supportsAggregablePercentiles;

    @Deprecated
    public DefaultLongTaskTimer(Meter.Id id, Clock clock) {
        this(id, clock, TimeUnit.MILLISECONDS, DistributionStatisticConfig.DEFAULT, false);
    }

    public DefaultLongTaskTimer(Meter.Id id, Clock clock, TimeUnit timeUnit, DistributionStatisticConfig distributionStatisticConfig, boolean bl2) {
        super(id);
        this.clock = clock;
        this.baseTimeUnit = timeUnit;
        this.distributionStatisticConfig = distributionStatisticConfig;
        this.supportsAggregablePercentiles = bl2;
    }

    @Override
    public LongTaskTimer.Sample start() {
        SampleImpl sampleImpl = new SampleImpl();
        this.activeTasks.add(sampleImpl);
        return sampleImpl;
    }

    @Override
    public double duration(TimeUnit timeUnit) {
        long l2 = this.clock.monotonicTime();
        long l3 = 0L;
        for (SampleImpl sampleImpl : this.activeTasks) {
            l3 += l2 - sampleImpl.startTime();
        }
        return TimeUtils.nanosToUnit(l3, timeUnit);
    }

    @Override
    public double max(TimeUnit timeUnit) {
        LongTaskTimer.Sample sample = this.activeTasks.peek();
        return sample == null ? 0.0 : sample.duration(timeUnit);
    }

    @Override
    public int activeTasks() {
        return this.activeTasks.size();
    }

    protected void forEachActive(Consumer<LongTaskTimer.Sample> consumer) {
        this.activeTasks.forEach(consumer);
    }

    @Override
    public TimeUnit baseTimeUnit() {
        return this.baseTimeUnit;
    }

    @Override
    public HistogramSnapshot takeSnapshot() {
        ArrayBlockingQueue arrayBlockingQueue = new ArrayBlockingQueue(this.distributionStatisticConfig.getPercentiles() == null ? 1 : this.distributionStatisticConfig.getPercentiles().length);
        double[] dArray = this.distributionStatisticConfig.getPercentiles();
        if (dArray != null && dArray.length > 0) {
            Arrays.stream(dArray).sorted().boxed().forEach(arrayBlockingQueue::add);
        }
        NavigableSet<Double> navigableSet = this.distributionStatisticConfig.getHistogramBuckets(this.supportsAggregablePercentiles);
        CountAtBucket[] countAtBucketArray = new CountAtBucket[]{};
        List list = arrayBlockingQueue.stream().filter(d2 -> d2 * (double)(this.activeTasks.size() + 1) > (double)this.activeTasks.size()).collect(Collectors.toList());
        arrayBlockingQueue.removeAll(list);
        ArrayList<ValueAtPercentile> arrayList = new ArrayList<ValueAtPercentile>(arrayBlockingQueue.size());
        if (!arrayBlockingQueue.isEmpty() || !navigableSet.isEmpty()) {
            Double d3 = (Double)arrayBlockingQueue.poll();
            Double d4 = navigableSet.pollFirst();
            ArrayList<CountAtBucket> arrayList2 = new ArrayList<CountAtBucket>(navigableSet.size());
            Double d5 = null;
            int n2 = 0;
            Object object = ((Stream)StreamSupport.stream(((Iterable)this.activeTasks::descendingIterator).spliterator(), false).sequential()).map(sampleImpl -> sampleImpl.duration(TimeUnit.NANOSECONDS)).collect(Collectors.toList());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                double d6;
                Double d7 = (Double)iterator.next();
                while (d4 != null && d7 > d4) {
                    arrayList2.add(new CountAtBucket(d4, (double)n2));
                    d4 = navigableSet.pollFirst();
                }
                ++n2;
                if (d3 != null && (double)n2 >= (d6 = d3 * (double)(this.activeTasks.size() + 1))) {
                    double d8 = d7;
                    if ((double)n2 != d6 && d5 != null) {
                        double d9 = d5;
                        d8 = d9 + (d8 - d9) * (d6 - (double)((int)d6));
                    }
                    arrayList.add(new ValueAtPercentile(d3, d8));
                    d3 = (Double)arrayBlockingQueue.poll();
                }
                d5 = d7;
            }
            while (d4 != null) {
                arrayList2.add(new CountAtBucket(d4, (double)n2));
                d4 = navigableSet.pollFirst();
            }
            countAtBucketArray = arrayList2.toArray(countAtBucketArray);
        }
        double d10 = this.duration(TimeUnit.NANOSECONDS);
        double d11 = this.max(TimeUnit.NANOSECONDS);
        for (Object object : list) {
            arrayList.add(new ValueAtPercentile((Double)object, d11));
        }
        ValueAtPercentile[] valueAtPercentileArray = arrayList.toArray(new ValueAtPercentile[0]);
        return new HistogramSnapshot(this.activeTasks.size(), d10, d11, valueAtPercentileArray, countAtBucketArray, (printStream, d2) -> printStream.print("Summary output for LongTaskTimer histograms is not supported."));
    }

    class SampleImpl
    extends LongTaskTimer.Sample {
        private final long startTime;
        private volatile boolean stopped;

        private SampleImpl() {
            this.startTime = DefaultLongTaskTimer.this.clock.monotonicTime();
        }

        @Override
        public long stop() {
            DefaultLongTaskTimer.this.activeTasks.remove(this);
            long l2 = (long)this.duration(TimeUnit.NANOSECONDS);
            this.stopped = true;
            return l2;
        }

        @Override
        public double duration(TimeUnit timeUnit) {
            return this.stopped ? -1.0 : TimeUtils.nanosToUnit(DefaultLongTaskTimer.this.clock.monotonicTime() - this.startTime, timeUnit);
        }

        private long startTime() {
            return this.startTime;
        }

        public String toString() {
            double d2 = this.duration(TimeUnit.NANOSECONDS);
            return "SampleImpl{duration(seconds)=" + TimeUtils.nanosToUnit(d2, TimeUnit.SECONDS) + ", duration(nanos)=" + d2 + ", startTimeNanos=" + this.startTime + '}';
        }
    }
}

