/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.instrument.internal;

import com.contrastsecurity.thirdparty.imm.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.imm.core.instrument.Tag;
import com.contrastsecurity.thirdparty.imm.core.instrument.Tags;
import com.contrastsecurity.thirdparty.imm.core.instrument.Timer;
import com.contrastsecurity.thirdparty.imm.core.instrument.internal.TimedCallable;
import com.contrastsecurity.thirdparty.imm.core.instrument.internal.TimedRunnable;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;

public class TimedExecutorService
implements ExecutorService {
    private final MeterRegistry registry;
    private final ExecutorService delegate;
    private final Timer executionTimer;
    private final Timer idleTimer;

    public TimedExecutorService(MeterRegistry meterRegistry, ExecutorService executorService, String string, String string2, Iterable<Tag> iterable) {
        this.registry = meterRegistry;
        this.delegate = executorService;
        Tags tags = Tags.concat(iterable, "name", string);
        this.executionTimer = meterRegistry.timer(string2 + "executor", tags);
        this.idleTimer = meterRegistry.timer(string2 + "executor.idle", tags);
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long l2, TimeUnit timeUnit) throws InterruptedException {
        return this.delegate.awaitTermination(l2, timeUnit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable) {
        return this.delegate.submit(this.wrap(callable));
    }

    @Override
    public <T> Future<T> submit(Runnable runnable, T t2) {
        return this.delegate.submit(this.wrap(runnable), t2);
    }

    @Override
    public Future<?> submit(Runnable runnable) {
        return this.delegate.submit(this.wrap(runnable));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection) throws InterruptedException {
        return this.delegate.invokeAll(this.wrapAll(collection));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection, long l2, TimeUnit timeUnit) throws InterruptedException {
        return this.delegate.invokeAll(this.wrapAll(collection), l2, timeUnit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection) throws InterruptedException, ExecutionException {
        return this.delegate.invokeAny(this.wrapAll(collection));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection, long l2, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.invokeAny(this.wrapAll(collection), l2, timeUnit);
    }

    @Override
    public void execute(Runnable runnable) {
        this.delegate.execute(this.wrap(runnable));
    }

    private Runnable wrap(Runnable runnable) {
        return new TimedRunnable(this.registry, this.executionTimer, this.idleTimer, runnable);
    }

    private <T> Callable<T> wrap(Callable<T> callable) {
        return new TimedCallable<T>(this.registry, this.executionTimer, this.idleTimer, callable);
    }

    private <T> Collection<? extends Callable<T>> wrapAll(Collection<? extends Callable<T>> collection) {
        return collection.stream().map(this::wrap).collect(Collectors.toList());
    }
}

