/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.instrument.step;

import com.contrastsecurity.thirdparty.imm.core.instrument.AbstractMeter;
import com.contrastsecurity.thirdparty.imm.core.instrument.Clock;
import com.contrastsecurity.thirdparty.imm.core.instrument.FunctionCounter;
import com.contrastsecurity.thirdparty.imm.core.instrument.Meter;
import com.contrastsecurity.thirdparty.imm.core.instrument.step.StepDouble;
import com.contrastsecurity.thirdparty.imm.core.instrument.step.StepMeter;
import java.lang.ref.WeakReference;
import java.util.function.ToDoubleFunction;

public class StepFunctionCounter<T>
extends AbstractMeter
implements FunctionCounter,
StepMeter {
    private final WeakReference<T> ref;
    private final ToDoubleFunction<T> f;
    private volatile double last;
    private StepDouble count;

    public StepFunctionCounter(Meter.Id id, Clock clock, long l2, T t2, ToDoubleFunction<T> toDoubleFunction) {
        super(id);
        this.ref = new WeakReference<T>(t2);
        this.f = toDoubleFunction;
        this.count = new StepDouble(clock, l2);
    }

    @Override
    public double count() {
        Object t2 = this.ref.get();
        if (t2 != null) {
            double d2 = this.last;
            this.last = this.f.applyAsDouble(t2);
            this.count.getCurrent().add(this.last - d2);
        }
        return (Double)this.count.poll();
    }

    @Override
    public void _closingRollover() {
        this.count();
        this.count._closingRollover();
    }
}

