/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.api.baggage.propagation;

import java.util.BitSet;
import javax.annotation.Nullable;

class Element {
    private static final BitSet EXCLUDED_KEY_CHARS = new BitSet(128);
    private static final BitSet EXCLUDED_VALUE_CHARS = new BitSet(128);
    private final BitSet excluded;
    private boolean leadingSpace;
    private boolean readingValue;
    private boolean trailingSpace;
    private int start;
    private int end;
    @Nullable
    private String value;

    static Element createKeyElement() {
        return new Element(EXCLUDED_KEY_CHARS);
    }

    static Element createValueElement() {
        return new Element(EXCLUDED_VALUE_CHARS);
    }

    private Element(BitSet bitSet) {
        this.excluded = bitSet;
        this.reset(0);
    }

    @Nullable
    String getValue() {
        return this.value;
    }

    void reset(int n2) {
        this.start = n2;
        this.leadingSpace = true;
        this.readingValue = false;
        this.trailingSpace = false;
        this.value = null;
    }

    boolean tryTerminating(int n2, String string) {
        if (this.readingValue) {
            this.markEnd(n2);
        }
        if (this.trailingSpace) {
            this.setValue(string);
            return true;
        }
        return false;
    }

    private void markEnd(int n2) {
        this.end = n2;
        this.readingValue = false;
        this.trailingSpace = true;
    }

    private void setValue(String string) {
        this.value = string.substring(this.start, this.end);
    }

    boolean tryNextChar(char c2, int n2) {
        if (Element.isWhitespace(c2)) {
            return this.tryNextWhitespace(n2);
        }
        if (this.isExcluded(c2)) {
            return false;
        }
        return this.tryNextTokenChar(n2);
    }

    private static boolean isWhitespace(char c2) {
        return c2 == ' ' || c2 == '\t';
    }

    private boolean tryNextWhitespace(int n2) {
        if (this.readingValue) {
            this.markEnd(n2);
        }
        return true;
    }

    private boolean isExcluded(char c2) {
        return c2 <= ' ' || c2 >= '\u007f' || this.excluded.get(c2);
    }

    private boolean tryNextTokenChar(int n2) {
        if (this.leadingSpace) {
            this.markStart(n2);
        }
        return !this.trailingSpace;
    }

    private void markStart(int n2) {
        this.start = n2;
        this.readingValue = true;
        this.leadingSpace = false;
    }

    static {
        for (char c2 : new char[]{'(', ')', '<', '>', '@', ',', ';', ':', '\\', '\"', '/', '[', ']', '?', '=', '{', '}'}) {
            EXCLUDED_KEY_CHARS.set(c2);
        }
        for (char c2 : new char[]{'\"', ',', ';', '\\'}) {
            EXCLUDED_VALUE_CHARS.set(c2);
        }
    }
}

