/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.api.common;

import com.contrastsecurity.thirdparty.iot.api.common.ArrayBackedAttributes;
import com.contrastsecurity.thirdparty.iot.api.common.AttributeKey;
import com.contrastsecurity.thirdparty.iot.api.common.Attributes;
import com.contrastsecurity.thirdparty.iot.api.common.AttributesBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

class ArrayBackedAttributesBuilder
implements AttributesBuilder {
    private final List<Object> data;

    ArrayBackedAttributesBuilder() {
        this.data = new ArrayList<Object>();
    }

    ArrayBackedAttributesBuilder(List<Object> list) {
        this.data = list;
    }

    @Override
    public Attributes build() {
        if (this.data.size() == 2 && this.data.get(0) != null) {
            return new ArrayBackedAttributes(this.data.toArray());
        }
        return ArrayBackedAttributes.sortAndFilterToAttributes(this.data.toArray());
    }

    @Override
    public <T> AttributesBuilder put(AttributeKey<Long> attributeKey, int n2) {
        return this.put((AttributeKey<T>)attributeKey, (T)Long.valueOf(n2));
    }

    @Override
    public <T> AttributesBuilder put(AttributeKey<T> attributeKey, T t2) {
        if (attributeKey == null || attributeKey.getKey().isEmpty() || t2 == null) {
            return this;
        }
        this.data.add(attributeKey);
        this.data.add(t2);
        return this;
    }

    @Override
    public AttributesBuilder putAll(Attributes attributes) {
        if (attributes == null) {
            return this;
        }
        attributes.forEach((attributeKey, object) -> this.put((AttributeKey<T>)((AttributeKey)attributeKey), (T)object));
        return this;
    }

    @Override
    public <T> AttributesBuilder remove(AttributeKey<T> attributeKey) {
        if (attributeKey == null || attributeKey.getKey().isEmpty()) {
            return this;
        }
        return this.removeIf(attributeKey2 -> attributeKey.getKey().equals(attributeKey2.getKey()) && attributeKey.getType().equals((Object)attributeKey2.getType()));
    }

    @Override
    public AttributesBuilder removeIf(Predicate<AttributeKey<?>> predicate) {
        if (predicate == null) {
            return this;
        }
        for (int i2 = 0; i2 < this.data.size() - 1; i2 += 2) {
            Object object = this.data.get(i2);
            if (!(object instanceof AttributeKey) || !predicate.test((AttributeKey)object)) continue;
            this.data.set(i2, null);
            this.data.set(i2 + 1, null);
        }
        return this;
    }

    static List<Double> toList(double ... dArray) {
        Double[] doubleArray = new Double[dArray.length];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            doubleArray[i2] = dArray[i2];
        }
        return Arrays.asList(doubleArray);
    }

    static List<Long> toList(long ... lArray) {
        Long[] longArray = new Long[lArray.length];
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            longArray[i2] = lArray[i2];
        }
        return Arrays.asList(longArray);
    }

    static List<Boolean> toList(boolean ... blArray) {
        Boolean[] booleanArray = new Boolean[blArray.length];
        for (int i2 = 0; i2 < blArray.length; ++i2) {
            booleanArray[i2] = blArray[i2];
        }
        return Arrays.asList(booleanArray);
    }
}

