/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.api.internal;

import com.contrastsecurity.thirdparty.iot.api.internal.TemporaryBuffers;
import javax.annotation.CheckForNull;

public final class PercentEscaper {
    private static final int DEST_PAD = 32;
    private static final String SAFE_CHARS = "-._~!$'()*&@:abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private static final char[] UPPER_HEX_DIGITS = "0123456789ABCDEF".toCharArray();
    private static final boolean[] safeOctets = PercentEscaper.createSafeOctets("-._~!$'()*&@:abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789");

    public static PercentEscaper create() {
        return new PercentEscaper();
    }

    /*
     * WARNING - void declaration
     */
    private static boolean[] createSafeOctets(String string) {
        void var6_10;
        char[] cArray;
        int n2 = -1;
        for (char c2 : cArray = string.toCharArray()) {
            n2 = Math.max(c2, n2);
        }
        boolean[] blArray = new boolean[n2 + 1];
        char[] cArray2 = cArray;
        int n3 = cArray2.length;
        boolean bl2 = false;
        while (var6_10 < n3) {
            char c3 = cArray2[var6_10];
            blArray[c3] = true;
            ++var6_10;
        }
        return blArray;
    }

    public String escape(String string) {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 < safeOctets.length && safeOctets[c2]) continue;
            return PercentEscaper.escapeSlow(string, i2);
        }
        return string;
    }

    private static String escapeSlow(String string, int n2) {
        int n3;
        int n4 = string.length();
        char[] cArray = TemporaryBuffers.chars(1024);
        int n5 = 0;
        int n6 = 0;
        while (n2 < n4) {
            n3 = PercentEscaper.codePointAt(string, n2, n4);
            if (n3 < 0) {
                throw new IllegalArgumentException("Trailing high surrogate at end of input");
            }
            char[] cArray2 = PercentEscaper.escape(n3);
            int n7 = n2 + (Character.isSupplementaryCodePoint(n3) ? 2 : 1);
            if (cArray2 != null) {
                int n8 = n2 - n6;
                int n9 = n5 + n8 + cArray2.length;
                if (cArray.length < n9) {
                    int n10 = n9 + (n4 - n2) + 32;
                    cArray = PercentEscaper.growBuffer(cArray, n5, n10);
                }
                if (n8 > 0) {
                    string.getChars(n6, n2, cArray, n5);
                    n5 += n8;
                }
                if (cArray2.length > 0) {
                    System.arraycopy(cArray2, 0, cArray, n5, cArray2.length);
                    n5 += cArray2.length;
                }
                n6 = n7;
            }
            n2 = PercentEscaper.nextEscapeIndex(string, n7, n4);
        }
        n3 = n4 - n6;
        if (n3 > 0) {
            int n11 = n5 + n3;
            if (cArray.length < n11) {
                cArray = PercentEscaper.growBuffer(cArray, n5, n11);
            }
            string.getChars(n6, n4, cArray, n5);
            n5 = n11;
        }
        return new String(cArray, 0, n5);
    }

    private static int nextEscapeIndex(CharSequence charSequence, int n2, int n3) {
        char c2;
        while (n2 < n3 && (c2 = charSequence.charAt(n2)) < safeOctets.length && safeOctets[c2]) {
            ++n2;
        }
        return n2;
    }

    @CheckForNull
    private static char[] escape(int n2) {
        if (n2 < safeOctets.length && safeOctets[n2]) {
            return null;
        }
        if (n2 <= 127) {
            char[] cArray = new char[3];
            cArray[0] = 37;
            cArray[2] = UPPER_HEX_DIGITS[n2 & 0xF];
            cArray[1] = UPPER_HEX_DIGITS[n2 >>> 4];
            return cArray;
        }
        if (n2 <= 2047) {
            char[] cArray = new char[6];
            cArray[0] = 37;
            cArray[3] = 37;
            cArray[5] = UPPER_HEX_DIGITS[n2 & 0xF];
            cArray[4] = UPPER_HEX_DIGITS[8 | (n2 >>>= 4) & 3];
            cArray[2] = UPPER_HEX_DIGITS[(n2 >>>= 2) & 0xF];
            cArray[1] = UPPER_HEX_DIGITS[0xC | (n2 >>>= 4)];
            return cArray;
        }
        if (n2 <= 65535) {
            char[] cArray = new char[9];
            cArray[0] = 37;
            cArray[1] = 69;
            cArray[3] = 37;
            cArray[6] = 37;
            cArray[8] = UPPER_HEX_DIGITS[n2 & 0xF];
            cArray[7] = UPPER_HEX_DIGITS[8 | (n2 >>>= 4) & 3];
            cArray[5] = UPPER_HEX_DIGITS[(n2 >>>= 2) & 0xF];
            cArray[4] = UPPER_HEX_DIGITS[8 | (n2 >>>= 4) & 3];
            cArray[2] = UPPER_HEX_DIGITS[n2 >>>= 2];
            return cArray;
        }
        if (n2 <= 0x10FFFF) {
            char[] cArray = new char[12];
            cArray[0] = 37;
            cArray[1] = 70;
            cArray[3] = 37;
            cArray[6] = 37;
            cArray[9] = 37;
            cArray[11] = UPPER_HEX_DIGITS[n2 & 0xF];
            cArray[10] = UPPER_HEX_DIGITS[8 | (n2 >>>= 4) & 3];
            cArray[8] = UPPER_HEX_DIGITS[(n2 >>>= 2) & 0xF];
            cArray[7] = UPPER_HEX_DIGITS[8 | (n2 >>>= 4) & 3];
            cArray[5] = UPPER_HEX_DIGITS[(n2 >>>= 2) & 0xF];
            cArray[4] = UPPER_HEX_DIGITS[8 | (n2 >>>= 4) & 3];
            cArray[2] = UPPER_HEX_DIGITS[(n2 >>>= 2) & 7];
            return cArray;
        }
        throw new IllegalArgumentException("Invalid unicode character value " + n2);
    }

    private static int codePointAt(CharSequence charSequence, int n2, int n3) {
        if (n2 < n3) {
            char c2;
            if ((c2 = charSequence.charAt(n2++)) < '\ud800' || c2 > '\udfff') {
                return c2;
            }
            if (c2 <= '\udbff') {
                if (n2 == n3) {
                    return -c2;
                }
                char c3 = charSequence.charAt(n2);
                if (Character.isLowSurrogate(c3)) {
                    return Character.toCodePoint(c2, c3);
                }
                throw new IllegalArgumentException("Expected low surrogate but got char '" + c3 + "' with value " + c3 + " at index " + n2 + " in '" + charSequence + "'");
            }
            throw new IllegalArgumentException("Unexpected low surrogate character '" + c2 + "' with value " + c2 + " at index " + (n2 - 1) + " in '" + charSequence + "'");
        }
        throw new IndexOutOfBoundsException("Index exceeds specified range");
    }

    private static char[] growBuffer(char[] cArray, int n2, int n3) {
        if (n3 < 0) {
            throw new AssertionError((Object)"Cannot increase internal buffer any further");
        }
        char[] cArray2 = new char[n3];
        if (n2 > 0) {
            System.arraycopy(cArray, 0, cArray2, 0, n2);
        }
        return cArray2;
    }
}

