/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.api.trace;

import com.contrastsecurity.thirdparty.iot.api.internal.StringUtils;
import com.contrastsecurity.thirdparty.iot.api.trace.ArrayBasedTraceState;
import com.contrastsecurity.thirdparty.iot.api.trace.TraceState;
import com.contrastsecurity.thirdparty.iot.api.trace.TraceStateBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

final class ArrayBasedTraceStateBuilder
implements TraceStateBuilder {
    private static final int MAX_VENDOR_ID_SIZE = 13;
    private static final ArrayBasedTraceState EMPTY = ArrayBasedTraceState.create(Collections.emptyList());
    private static final int MAX_ENTRIES = 32;
    private static final int KEY_MAX_SIZE = 256;
    private static final int VALUE_MAX_SIZE = 256;
    private static final int MAX_TENANT_ID_SIZE = 240;
    private final List<String> reversedEntries;
    int numEntries;

    static TraceState empty() {
        return EMPTY;
    }

    ArrayBasedTraceStateBuilder() {
        this.reversedEntries = new ArrayList<String>();
        this.numEntries = 0;
    }

    ArrayBasedTraceStateBuilder(ArrayBasedTraceState arrayBasedTraceState) {
        List<String> list = arrayBasedTraceState.getEntries();
        int n2 = list.size();
        this.reversedEntries = new ArrayList<String>(n2);
        for (int i2 = n2 - 2; i2 >= 0; i2 -= 2) {
            this.reversedEntries.add(list.get(i2));
            this.reversedEntries.add(list.get(i2 + 1));
        }
        this.numEntries = n2 / 2;
    }

    @Override
    public TraceStateBuilder put(String string, String string2) {
        if (!ArrayBasedTraceStateBuilder.isKeyValid(string) || !ArrayBasedTraceStateBuilder.isValueValid(string2) || this.numEntries >= 32) {
            return this;
        }
        for (int i2 = 0; i2 < this.reversedEntries.size(); i2 += 2) {
            if (!this.reversedEntries.get(i2).equals(string)) continue;
            String string3 = this.reversedEntries.get(i2 + 1);
            this.reversedEntries.set(i2 + 1, string2);
            if (string3 == null) {
                ++this.numEntries;
            }
            return this;
        }
        this.reversedEntries.add(string);
        this.reversedEntries.add(string2);
        ++this.numEntries;
        return this;
    }

    @Override
    public TraceStateBuilder remove(String string) {
        if (string == null) {
            return this;
        }
        for (int i2 = 0; i2 < this.reversedEntries.size(); i2 += 2) {
            if (!this.reversedEntries.get(i2).equals(string)) continue;
            this.reversedEntries.set(i2 + 1, null);
            --this.numEntries;
            return this;
        }
        return this;
    }

    @Override
    public TraceState build() {
        if (this.numEntries == 0) {
            return ArrayBasedTraceStateBuilder.empty();
        }
        if (this.reversedEntries.size() == 2) {
            return ArrayBasedTraceState.create(new ArrayList<String>(this.reversedEntries));
        }
        String[] stringArray = new String[this.numEntries * 2];
        int n2 = 0;
        for (int i2 = this.reversedEntries.size() - 2; i2 >= 0; i2 -= 2) {
            String string = this.reversedEntries.get(i2);
            String string2 = this.reversedEntries.get(i2 + 1);
            if (string2 == null) continue;
            stringArray[n2++] = string;
            stringArray[n2++] = string2;
        }
        return ArrayBasedTraceState.create(Arrays.asList(stringArray));
    }

    private static boolean isKeyValid(@Nullable String string) {
        if (string == null) {
            return false;
        }
        if (string.length() > 256 || string.isEmpty() || ArrayBasedTraceStateBuilder.isNotLowercaseLetterOrDigit(string.charAt(0))) {
            return false;
        }
        boolean bl2 = false;
        for (int i2 = 1; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (ArrayBasedTraceStateBuilder.isNotLegalKeyCharacter(c2)) {
                return false;
            }
            if (c2 != '@') continue;
            if (bl2) {
                return false;
            }
            bl2 = true;
            if (i2 > 240) {
                return false;
            }
            int n2 = string.length() - i2 - 1;
            if (n2 <= 13 && n2 != 0) continue;
            return false;
        }
        if (!bl2) {
            return ArrayBasedTraceStateBuilder.isNotDigit(string.charAt(0));
        }
        return true;
    }

    private static boolean isNotLegalKeyCharacter(char c2) {
        return ArrayBasedTraceStateBuilder.isNotLowercaseLetterOrDigit(c2) && c2 != '_' && c2 != '-' && c2 != '@' && c2 != '*' && c2 != '/';
    }

    private static boolean isNotLowercaseLetterOrDigit(char c2) {
        return (c2 < 'a' || c2 > 'z') && ArrayBasedTraceStateBuilder.isNotDigit(c2);
    }

    private static boolean isNotDigit(char c2) {
        return c2 < '0' || c2 > '9';
    }

    private static boolean isValueValid(@Nullable String string) {
        if (StringUtils.isNullOrEmpty(string)) {
            return false;
        }
        if (string.length() > 256 || string.charAt(string.length() - 1) == ' ') {
            return false;
        }
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 != ',' && c2 != '=' && c2 >= ' ' && c2 <= '~') continue;
            return false;
        }
        return true;
    }
}

