/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.context;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.cggl.errorprone.annotations.MustBeClosed;
import com.contrastsecurity.thirdparty.iot.context.ContextExecutorService;
import com.contrastsecurity.thirdparty.iot.context.ContextKey;
import com.contrastsecurity.thirdparty.iot.context.ContextScheduledExecutorService;
import com.contrastsecurity.thirdparty.iot.context.ContextStorage;
import com.contrastsecurity.thirdparty.iot.context.CurrentContextExecutorService;
import com.contrastsecurity.thirdparty.iot.context.ImplicitContextKeyed;
import com.contrastsecurity.thirdparty.iot.context.Scope;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public interface Context {
    public static Context current() {
        Context context = ContextStorage.get().current();
        return context != null ? context : Context.root();
    }

    public static Context root() {
        return ContextStorage.get().root();
    }

    public static Executor taskWrapping(Executor executor) {
        return runnable -> executor.execute(Context.current().wrap(runnable));
    }

    public static ExecutorService taskWrapping(ExecutorService executorService) {
        return new CurrentContextExecutorService(executorService);
    }

    @Nullable
    public <V> V get(ContextKey<V> var1);

    public <V> Context with(ContextKey<V> var1, V var2);

    default public Context with(ImplicitContextKeyed implicitContextKeyed) {
        return implicitContextKeyed.storeInContext(this);
    }

    @MustBeClosed
    default public Scope makeCurrent() {
        return ContextStorage.get().attach(this);
    }

    default public Runnable wrap(Runnable runnable) {
        return () -> {
            Scope scope = this.makeCurrent();
            try {
                runnable.run();
                if (scope != null) {
                    scope.close();
                }
            }
            catch (Throwable throwable) {
                Throwables.throwIfCritical(throwable);
                Throwable throwable2 = throwable;
                if (scope != null) {
                    try {
                        scope.close();
                    }
                    catch (Throwable throwable3) {
                        Throwables.throwIfCritical(throwable3);
                        Throwable throwable4 = throwable3;
                        throwable2.addSuppressed(throwable4);
                    }
                }
                throw throwable2;
            }
        };
    }

    default public <T> Callable<T> wrap(Callable<T> callable) {
        return () -> {
            Scope scope = this.makeCurrent();
            try {
                Object v2 = callable.call();
                if (scope != null) {
                    scope.close();
                }
                return v2;
            }
            catch (Throwable throwable) {
                Throwables.throwIfCritical(throwable);
                Throwable throwable2 = throwable;
                if (scope != null) {
                    try {
                        scope.close();
                    }
                    catch (Throwable throwable3) {
                        Throwables.throwIfCritical(throwable3);
                        Throwable throwable4 = throwable3;
                        throwable2.addSuppressed(throwable4);
                    }
                }
                throw throwable2;
            }
        };
    }

    default public Executor wrap(Executor executor) {
        return runnable -> executor.execute(this.wrap(runnable));
    }

    default public ExecutorService wrap(ExecutorService executorService) {
        return new ContextExecutorService(this, executorService);
    }

    default public ScheduledExecutorService wrap(ScheduledExecutorService scheduledExecutorService) {
        return new ContextScheduledExecutorService(this, scheduledExecutorService);
    }

    default public <T, U> Function<T, U> wrapFunction(Function<T, U> function) {
        return object -> {
            Scope scope = this.makeCurrent();
            try {
                Object r2 = function.apply(object);
                if (scope != null) {
                    scope.close();
                }
                return r2;
            }
            catch (Throwable throwable) {
                Throwables.throwIfCritical(throwable);
                Throwable throwable2 = throwable;
                if (scope != null) {
                    try {
                        scope.close();
                    }
                    catch (Throwable throwable3) {
                        Throwables.throwIfCritical(throwable3);
                        Throwable throwable4 = throwable3;
                        throwable2.addSuppressed(throwable4);
                    }
                }
                throw throwable2;
            }
        };
    }

    default public <T, U, V> BiFunction<T, U, V> wrapFunction(BiFunction<T, U, V> biFunction) {
        return (object, object2) -> {
            Scope scope = this.makeCurrent();
            try {
                Object r2 = biFunction.apply(object, object2);
                if (scope != null) {
                    scope.close();
                }
                return r2;
            }
            catch (Throwable throwable) {
                Throwables.throwIfCritical(throwable);
                Throwable throwable2 = throwable;
                if (scope != null) {
                    try {
                        scope.close();
                    }
                    catch (Throwable throwable3) {
                        Throwables.throwIfCritical(throwable3);
                        Throwable throwable4 = throwable3;
                        throwable2.addSuppressed(throwable4);
                    }
                }
                throw throwable2;
            }
        };
    }

    default public <T> Consumer<T> wrapConsumer(Consumer<T> consumer) {
        return object -> {
            Scope scope = this.makeCurrent();
            try {
                consumer.accept(object);
                if (scope != null) {
                    scope.close();
                }
            }
            catch (Throwable throwable) {
                Throwables.throwIfCritical(throwable);
                Throwable throwable2 = throwable;
                if (scope != null) {
                    try {
                        scope.close();
                    }
                    catch (Throwable throwable3) {
                        Throwables.throwIfCritical(throwable3);
                        Throwable throwable4 = throwable3;
                        throwable2.addSuppressed(throwable4);
                    }
                }
                throw throwable2;
            }
        };
    }

    default public <T, U> BiConsumer<T, U> wrapConsumer(BiConsumer<T, U> biConsumer) {
        return (object, object2) -> {
            Scope scope = this.makeCurrent();
            try {
                biConsumer.accept(object, object2);
                if (scope != null) {
                    scope.close();
                }
            }
            catch (Throwable throwable) {
                Throwables.throwIfCritical(throwable);
                Throwable throwable2 = throwable;
                if (scope != null) {
                    try {
                        scope.close();
                    }
                    catch (Throwable throwable3) {
                        Throwables.throwIfCritical(throwable3);
                        Throwable throwable4 = throwable3;
                        throwable2.addSuppressed(throwable4);
                    }
                }
                throw throwable2;
            }
        };
    }

    default public <T> Supplier<T> wrapSupplier(Supplier<T> supplier) {
        return () -> {
            Scope scope = this.makeCurrent();
            try {
                Object t2 = supplier.get();
                if (scope != null) {
                    scope.close();
                }
                return t2;
            }
            catch (Throwable throwable) {
                Throwables.throwIfCritical(throwable);
                Throwable throwable2 = throwable;
                if (scope != null) {
                    try {
                        scope.close();
                    }
                    catch (Throwable throwable3) {
                        Throwables.throwIfCritical(throwable3);
                        Throwable throwable4 = throwable3;
                        throwable2.addSuppressed(throwable4);
                    }
                }
                throw throwable2;
            }
        };
    }
}

