/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.exporter.internal.marshal;

import com.contrastsecurity.thirdparty.iot.exporter.internal.marshal.WireFormat;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public final class CodedInputStream {
    private final byte[] buffer;
    private final int limit;
    private int pos;
    private int lastTag;

    public static CodedInputStream newInstance(byte[] byArray) {
        return new CodedInputStream(byArray);
    }

    private CodedInputStream(byte[] byArray) {
        this.buffer = byArray;
        this.limit = byArray.length;
        this.pos = 0;
    }

    public int readTag() throws IOException {
        if (this.isAtEnd()) {
            this.lastTag = 0;
            return 0;
        }
        this.lastTag = this.readRawVarint32();
        if (WireFormat.getTagFieldNumber(this.lastTag) == 0) {
            throw new IOException("Invalid tag: " + this.lastTag);
        }
        return this.lastTag;
    }

    public String readStringRequireUtf8() throws IOException {
        int n2 = this.readRawVarint32();
        if (n2 > 0 && n2 <= this.limit - this.pos) {
            String string = new String(this.buffer, this.pos, n2, StandardCharsets.UTF_8);
            this.pos += n2;
            return string;
        }
        if (n2 == 0) {
            return "";
        }
        if (n2 <= 0) {
            throw CodedInputStream.newNegativeException();
        }
        throw CodedInputStream.newTruncatedException();
    }

    public boolean skipField(int n2) throws IOException {
        switch (WireFormat.getTagWireType(n2)) {
            case 0: {
                this.skipRawVarint();
                return true;
            }
            case 1: {
                this.skipRawBytes(8);
                return true;
            }
            case 2: {
                this.skipRawBytes(this.readRawVarint32());
                return true;
            }
            case 5: {
                this.skipRawBytes(4);
                return true;
            }
        }
        throw new IOException("Invalid wire type: " + n2);
    }

    private boolean isAtEnd() {
        return this.pos == this.limit;
    }

    public int readRawVarint32() throws IOException {
        block4: {
            int n2;
            int n3;
            block6: {
                byte[] byArray;
                block8: {
                    block7: {
                        block5: {
                            n3 = this.pos;
                            if (this.limit == n3) break block4;
                            byArray = this.buffer;
                            if ((n2 = byArray[n3++]) >= 0) {
                                this.pos = n3;
                                return n2;
                            }
                            if (this.limit - n3 < 9) break block4;
                            if ((n2 ^= byArray[n3++] << 7) >= 0) break block5;
                            n2 ^= 0xFFFFFF80;
                            break block6;
                        }
                        if ((n2 ^= byArray[n3++] << 14) < 0) break block7;
                        n2 ^= 0x3F80;
                        break block6;
                    }
                    if ((n2 ^= byArray[n3++] << 21) >= 0) break block8;
                    n2 ^= 0xFFE03F80;
                    break block6;
                }
                byte by = byArray[n3++];
                n2 ^= by << 28;
                n2 ^= 0xFE03F80;
                if (by < 0 && byArray[n3++] < 0 && byArray[n3++] < 0 && byArray[n3++] < 0 && byArray[n3++] < 0 && byArray[n3++] < 0) break block4;
            }
            this.pos = n3;
            return n2;
        }
        return (int)this.readRawVarint64SlowPath();
    }

    private long readRawVarint64SlowPath() throws IOException {
        long l2 = 0L;
        for (int i2 = 0; i2 < 64; i2 += 7) {
            byte by = this.readRawByte();
            l2 |= (long)(by & 0x7F) << i2;
            if ((by & 0x80) != 0) continue;
            return l2;
        }
        throw CodedInputStream.newMalformedVarintException();
    }

    private byte readRawByte() throws IOException {
        if (this.pos == this.limit) {
            throw CodedInputStream.newTruncatedException();
        }
        return this.buffer[this.pos++];
    }

    private void skipRawVarint() throws IOException {
        if (this.limit - this.pos >= 10) {
            this.skipRawVarintFastPath();
        } else {
            this.skipRawVarintSlowPath();
        }
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readRawLittleEndian64());
    }

    private long readRawLittleEndian64() throws IOException {
        int n2 = this.pos;
        if (this.limit - n2 < 8) {
            throw CodedInputStream.newTruncatedException();
        }
        byte[] byArray = this.buffer;
        this.pos = n2 + 8;
        return (long)byArray[n2] & 0xFFL | ((long)byArray[n2 + 1] & 0xFFL) << 8 | ((long)byArray[n2 + 2] & 0xFFL) << 16 | ((long)byArray[n2 + 3] & 0xFFL) << 24 | ((long)byArray[n2 + 4] & 0xFFL) << 32 | ((long)byArray[n2 + 5] & 0xFFL) << 40 | ((long)byArray[n2 + 6] & 0xFFL) << 48 | ((long)byArray[n2 + 7] & 0xFFL) << 56;
    }

    private void skipRawVarintFastPath() throws IOException {
        for (int i2 = 0; i2 < 10; ++i2) {
            if (this.buffer[this.pos++] < 0) continue;
            return;
        }
        throw CodedInputStream.newMalformedVarintException();
    }

    private void skipRawVarintSlowPath() throws IOException {
        for (int i2 = 0; i2 < 10; ++i2) {
            if (this.readRawByte() < 0) continue;
            return;
        }
        throw CodedInputStream.newMalformedVarintException();
    }

    private void skipRawBytes(int n2) throws IOException {
        if (n2 >= 0 && n2 <= this.limit - this.pos) {
            this.pos += n2;
            return;
        }
        if (n2 < 0) {
            throw CodedInputStream.newNegativeException();
        }
        throw CodedInputStream.newTruncatedException();
    }

    private static IOException newNegativeException() {
        return new IOException("CodedInputStream encountered an embedded string or message which claimed to have negative size.");
    }

    private static IOException newTruncatedException() {
        return new IOException("While parsing a protocol message, the input ended unexpectedly in the middle of a field.  This could mean either that the input has been truncated or that an embedded message misreported its own length.");
    }

    private static IOException newMalformedVarintException() {
        return new IOException("CodedInputStream encountered a malformed varint.");
    }
}

