/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.exporter.internal.otlp;

import com.contrastsecurity.thirdparty.iot.api.common.AttributeKey;
import com.contrastsecurity.thirdparty.iot.api.common.Attributes;
import com.contrastsecurity.thirdparty.iot.api.internal.InternalAttributeKeyImpl;
import com.contrastsecurity.thirdparty.iot.exporter.internal.marshal.CodedOutputStream;
import com.contrastsecurity.thirdparty.iot.exporter.internal.marshal.Marshaler;
import com.contrastsecurity.thirdparty.iot.exporter.internal.marshal.MarshalerUtil;
import com.contrastsecurity.thirdparty.iot.exporter.internal.marshal.MarshalerWithSize;
import com.contrastsecurity.thirdparty.iot.exporter.internal.marshal.ProtoFieldInfo;
import com.contrastsecurity.thirdparty.iot.exporter.internal.marshal.Serializer;
import com.contrastsecurity.thirdparty.iot.exporter.internal.otlp.StringAnyValueMarshaler;
import com.contrastsecurity.thirdparty.iot.proto.common.v1.internal.AnyValue;
import com.contrastsecurity.thirdparty.iot.proto.common.v1.internal.ArrayValue;
import com.contrastsecurity.thirdparty.iot.proto.common.v1.internal.KeyValue;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.BiConsumer;

public final class KeyValueMarshaler
extends MarshalerWithSize {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final KeyValueMarshaler[] EMPTY_REPEATED = new KeyValueMarshaler[0];
    private final byte[] keyUtf8;
    private final Marshaler value;

    public static KeyValueMarshaler[] createRepeated(Attributes attributes) {
        if (attributes.isEmpty()) {
            return EMPTY_REPEATED;
        }
        final KeyValueMarshaler[] keyValueMarshalerArray = new KeyValueMarshaler[attributes.size()];
        attributes.forEach(new BiConsumer<AttributeKey<?>, Object>(){
            int index = 0;

            @Override
            public void accept(AttributeKey<?> attributeKey, Object object) {
                keyValueMarshalerArray[this.index++] = KeyValueMarshaler.create(attributeKey, object);
            }
        });
        return keyValueMarshalerArray;
    }

    private static KeyValueMarshaler create(AttributeKey<?> attributeKey, Object object) {
        byte[] byArray = attributeKey.getKey().isEmpty() ? EMPTY_BYTES : (attributeKey instanceof InternalAttributeKeyImpl ? ((InternalAttributeKeyImpl)attributeKey).getKeyUtf8() : attributeKey.getKey().getBytes(StandardCharsets.UTF_8));
        switch (attributeKey.getType()) {
            case STRING: {
                return new KeyValueMarshaler(byArray, new StringAnyValueMarshaler(MarshalerUtil.toBytes((String)object)));
            }
            case LONG: {
                return new KeyValueMarshaler(byArray, new Int64AnyValueMarshaler((Long)object));
            }
            case BOOLEAN: {
                return new KeyValueMarshaler(byArray, new BoolAnyValueMarshaler((Boolean)object));
            }
            case DOUBLE: {
                return new KeyValueMarshaler(byArray, new AnyDoubleFieldMarshaler((Double)object));
            }
            case STRING_ARRAY: {
                return new KeyValueMarshaler(byArray, new ArrayAnyValueMarshaler(ArrayValueMarshaler.createString((List)object)));
            }
            case LONG_ARRAY: {
                return new KeyValueMarshaler(byArray, new ArrayAnyValueMarshaler(ArrayValueMarshaler.createInt64((List)object)));
            }
            case BOOLEAN_ARRAY: {
                return new KeyValueMarshaler(byArray, new ArrayAnyValueMarshaler(ArrayValueMarshaler.createBool((List)object)));
            }
            case DOUBLE_ARRAY: {
                return new KeyValueMarshaler(byArray, new ArrayAnyValueMarshaler(ArrayValueMarshaler.createDouble((List)object)));
            }
        }
        throw new IllegalArgumentException("Unsupported attribute type.");
    }

    private KeyValueMarshaler(byte[] byArray, Marshaler marshaler) {
        super(KeyValueMarshaler.calculateSize(byArray, marshaler));
        this.keyUtf8 = byArray;
        this.value = marshaler;
    }

    @Override
    public void writeTo(Serializer serializer) throws IOException {
        serializer.serializeString(KeyValue.KEY, this.keyUtf8);
        serializer.serializeMessage(KeyValue.VALUE, this.value);
    }

    private static int calculateSize(byte[] byArray, Marshaler marshaler) {
        int n2 = 0;
        n2 += MarshalerUtil.sizeBytes(KeyValue.KEY, byArray);
        return n2 += MarshalerUtil.sizeMessage(KeyValue.VALUE, marshaler);
    }

    private static class Int64AnyValueMarshaler
    extends MarshalerWithSize {
        private final long value;

        Int64AnyValueMarshaler(long l2) {
            super(Int64AnyValueMarshaler.calculateSize(l2));
            this.value = l2;
        }

        @Override
        public void writeTo(Serializer serializer) throws IOException {
            serializer.writeInt64(AnyValue.INT_VALUE, this.value);
        }

        private static int calculateSize(long l2) {
            return AnyValue.INT_VALUE.getTagSize() + CodedOutputStream.computeInt64SizeNoTag(l2);
        }
    }

    private static class BoolAnyValueMarshaler
    extends MarshalerWithSize {
        private final boolean value;

        BoolAnyValueMarshaler(boolean bl2) {
            super(BoolAnyValueMarshaler.calculateSize(bl2));
            this.value = bl2;
        }

        @Override
        public void writeTo(Serializer serializer) throws IOException {
            serializer.writeBool(AnyValue.BOOL_VALUE, this.value);
        }

        private static int calculateSize(boolean bl2) {
            return AnyValue.BOOL_VALUE.getTagSize() + CodedOutputStream.computeBoolSizeNoTag(bl2);
        }
    }

    private static class AnyDoubleFieldMarshaler
    extends MarshalerWithSize {
        private final double value;

        AnyDoubleFieldMarshaler(double d2) {
            super(AnyDoubleFieldMarshaler.calculateSize(d2));
            this.value = d2;
        }

        @Override
        public void writeTo(Serializer serializer) throws IOException {
            serializer.writeDouble(AnyValue.DOUBLE_VALUE, this.value);
        }

        private static int calculateSize(double d2) {
            return AnyValue.DOUBLE_VALUE.getTagSize() + CodedOutputStream.computeDoubleSizeNoTag(d2);
        }
    }

    private static class ArrayAnyValueMarshaler
    extends MarshalerWithSize {
        private final Marshaler value;

        private ArrayAnyValueMarshaler(Marshaler marshaler) {
            super(ArrayAnyValueMarshaler.calculateSize(marshaler));
            this.value = marshaler;
        }

        @Override
        public void writeTo(Serializer serializer) throws IOException {
            serializer.serializeMessage(AnyValue.ARRAY_VALUE, this.value);
        }

        private static int calculateSize(Marshaler marshaler) {
            return MarshalerUtil.sizeMessage(AnyValue.ARRAY_VALUE, marshaler);
        }
    }

    private static class ArrayValueMarshaler
    extends MarshalerWithSize {
        private final Marshaler[] values;

        static ArrayValueMarshaler createString(List<String> list) {
            int n2 = list.size();
            Marshaler[] marshalerArray = new StringAnyValueMarshaler[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                marshalerArray[i2] = new StringAnyValueMarshaler(list.get(i2).getBytes(StandardCharsets.UTF_8));
            }
            return new ArrayValueMarshaler(marshalerArray);
        }

        static ArrayValueMarshaler createBool(List<Boolean> list) {
            int n2 = list.size();
            Marshaler[] marshalerArray = new BoolAnyValueMarshaler[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                marshalerArray[i2] = new BoolAnyValueMarshaler(list.get(i2));
            }
            return new ArrayValueMarshaler(marshalerArray);
        }

        static ArrayValueMarshaler createInt64(List<Long> list) {
            int n2 = list.size();
            Marshaler[] marshalerArray = new Int64AnyValueMarshaler[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                marshalerArray[i2] = new Int64AnyValueMarshaler(list.get(i2));
            }
            return new ArrayValueMarshaler(marshalerArray);
        }

        static ArrayValueMarshaler createDouble(List<Double> list) {
            int n2 = list.size();
            Marshaler[] marshalerArray = new AnyDoubleFieldMarshaler[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                marshalerArray[i2] = new AnyDoubleFieldMarshaler(list.get(i2));
            }
            return new ArrayValueMarshaler(marshalerArray);
        }

        private ArrayValueMarshaler(Marshaler[] marshalerArray) {
            super(ArrayValueMarshaler.calculateSize(marshalerArray));
            this.values = marshalerArray;
        }

        @Override
        public void writeTo(Serializer serializer) throws IOException {
            serializer.serializeRepeatedMessage(ArrayValue.VALUES, this.values);
        }

        private static int calculateSize(Marshaler[] marshalerArray) {
            return MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)ArrayValue.VALUES, (Marshaler[])marshalerArray);
        }
    }
}

