/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.exporter.internal.otlp.logs;

import com.contrastsecurity.thirdparty.iot.api.logs.Severity;
import com.contrastsecurity.thirdparty.iot.api.trace.SpanContext;
import com.contrastsecurity.thirdparty.iot.api.trace.SpanId;
import com.contrastsecurity.thirdparty.iot.api.trace.TraceFlags;
import com.contrastsecurity.thirdparty.iot.api.trace.TraceId;
import com.contrastsecurity.thirdparty.iot.exporter.internal.marshal.Marshaler;
import com.contrastsecurity.thirdparty.iot.exporter.internal.marshal.MarshalerUtil;
import com.contrastsecurity.thirdparty.iot.exporter.internal.marshal.MarshalerWithSize;
import com.contrastsecurity.thirdparty.iot.exporter.internal.marshal.ProtoEnumInfo;
import com.contrastsecurity.thirdparty.iot.exporter.internal.marshal.ProtoFieldInfo;
import com.contrastsecurity.thirdparty.iot.exporter.internal.marshal.Serializer;
import com.contrastsecurity.thirdparty.iot.exporter.internal.otlp.KeyValueMarshaler;
import com.contrastsecurity.thirdparty.iot.exporter.internal.otlp.StringAnyValueMarshaler;
import com.contrastsecurity.thirdparty.iot.proto.logs.v1.internal.LogRecord;
import com.contrastsecurity.thirdparty.iot.proto.logs.v1.internal.SeverityNumber;
import com.contrastsecurity.thirdparty.iot.sdk.logs.data.LogRecordData;
import java.io.IOException;
import javax.annotation.Nullable;

final class LogMarshaler
extends MarshalerWithSize {
    private static final String INVALID_TRACE_ID = TraceId.getInvalid();
    private static final String INVALID_SPAN_ID = SpanId.getInvalid();
    private final long timeUnixNano;
    private final long observedTimeUnixNano;
    private final ProtoEnumInfo severityNumber;
    private final byte[] severityText;
    private final MarshalerWithSize anyValueMarshaler;
    private final KeyValueMarshaler[] attributeMarshalers;
    private final int droppedAttributesCount;
    private final TraceFlags traceFlags;
    @Nullable
    private final String traceId;
    @Nullable
    private final String spanId;

    static LogMarshaler create(LogRecordData logRecordData) {
        KeyValueMarshaler[] keyValueMarshalerArray = KeyValueMarshaler.createRepeated(logRecordData.getAttributes());
        StringAnyValueMarshaler stringAnyValueMarshaler = new StringAnyValueMarshaler(MarshalerUtil.toBytes(logRecordData.getBody().asString()));
        SpanContext spanContext = logRecordData.getSpanContext();
        return new LogMarshaler(logRecordData.getTimestampEpochNanos(), logRecordData.getObservedTimestampEpochNanos(), LogMarshaler.toProtoSeverityNumber(logRecordData.getSeverity()), MarshalerUtil.toBytes(logRecordData.getSeverityText()), stringAnyValueMarshaler, keyValueMarshalerArray, logRecordData.getTotalAttributeCount() - logRecordData.getAttributes().size(), spanContext.getTraceFlags(), spanContext.getTraceId().equals(INVALID_TRACE_ID) ? null : spanContext.getTraceId(), spanContext.getSpanId().equals(INVALID_SPAN_ID) ? null : spanContext.getSpanId());
    }

    private LogMarshaler(long l2, long l3, ProtoEnumInfo protoEnumInfo, byte[] byArray, MarshalerWithSize marshalerWithSize, KeyValueMarshaler[] keyValueMarshalerArray, int n2, TraceFlags traceFlags, @Nullable String string, @Nullable String string2) {
        super(LogMarshaler.calculateSize(l2, l3, protoEnumInfo, byArray, marshalerWithSize, keyValueMarshalerArray, n2, traceFlags, string, string2));
        this.timeUnixNano = l2;
        this.observedTimeUnixNano = l3;
        this.traceId = string;
        this.spanId = string2;
        this.traceFlags = traceFlags;
        this.severityNumber = protoEnumInfo;
        this.severityText = byArray;
        this.anyValueMarshaler = marshalerWithSize;
        this.attributeMarshalers = keyValueMarshalerArray;
        this.droppedAttributesCount = n2;
    }

    @Override
    protected void writeTo(Serializer serializer) throws IOException {
        serializer.serializeFixed64(LogRecord.TIME_UNIX_NANO, this.timeUnixNano);
        serializer.serializeFixed64(LogRecord.OBSERVED_TIME_UNIX_NANO, this.observedTimeUnixNano);
        serializer.serializeEnum(LogRecord.SEVERITY_NUMBER, this.severityNumber);
        serializer.serializeString(LogRecord.SEVERITY_TEXT, this.severityText);
        serializer.serializeMessage(LogRecord.BODY, this.anyValueMarshaler);
        serializer.serializeRepeatedMessage(LogRecord.ATTRIBUTES, this.attributeMarshalers);
        serializer.serializeUInt32(LogRecord.DROPPED_ATTRIBUTES_COUNT, this.droppedAttributesCount);
        serializer.serializeFixed32(LogRecord.FLAGS, LogMarshaler.toUnsignedInt(this.traceFlags.asByte()));
        serializer.serializeTraceId(LogRecord.TRACE_ID, this.traceId);
        serializer.serializeSpanId(LogRecord.SPAN_ID, this.spanId);
    }

    private static int calculateSize(long l2, long l3, ProtoEnumInfo protoEnumInfo, byte[] byArray, MarshalerWithSize marshalerWithSize, KeyValueMarshaler[] keyValueMarshalerArray, int n2, TraceFlags traceFlags, @Nullable String string, @Nullable String string2) {
        int n3 = 0;
        n3 += MarshalerUtil.sizeFixed64(LogRecord.TIME_UNIX_NANO, l2);
        n3 += MarshalerUtil.sizeFixed64(LogRecord.OBSERVED_TIME_UNIX_NANO, l3);
        n3 += MarshalerUtil.sizeEnum(LogRecord.SEVERITY_NUMBER, protoEnumInfo);
        n3 += MarshalerUtil.sizeBytes(LogRecord.SEVERITY_TEXT, byArray);
        n3 += MarshalerUtil.sizeMessage(LogRecord.BODY, marshalerWithSize);
        n3 += MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)LogRecord.ATTRIBUTES, (Marshaler[])keyValueMarshalerArray);
        n3 += MarshalerUtil.sizeUInt32(LogRecord.DROPPED_ATTRIBUTES_COUNT, n2);
        n3 += MarshalerUtil.sizeFixed32(LogRecord.FLAGS, LogMarshaler.toUnsignedInt(traceFlags.asByte()));
        n3 += MarshalerUtil.sizeTraceId(LogRecord.TRACE_ID, string);
        return n3 += MarshalerUtil.sizeSpanId(LogRecord.SPAN_ID, string2);
    }

    static ProtoEnumInfo toProtoSeverityNumber(Severity severity) {
        switch (severity) {
            case TRACE: {
                return SeverityNumber.SEVERITY_NUMBER_TRACE;
            }
            case TRACE2: {
                return SeverityNumber.SEVERITY_NUMBER_TRACE2;
            }
            case TRACE3: {
                return SeverityNumber.SEVERITY_NUMBER_TRACE3;
            }
            case TRACE4: {
                return SeverityNumber.SEVERITY_NUMBER_TRACE4;
            }
            case DEBUG: {
                return SeverityNumber.SEVERITY_NUMBER_DEBUG;
            }
            case DEBUG2: {
                return SeverityNumber.SEVERITY_NUMBER_DEBUG2;
            }
            case DEBUG3: {
                return SeverityNumber.SEVERITY_NUMBER_DEBUG3;
            }
            case DEBUG4: {
                return SeverityNumber.SEVERITY_NUMBER_DEBUG4;
            }
            case INFO: {
                return SeverityNumber.SEVERITY_NUMBER_INFO;
            }
            case INFO2: {
                return SeverityNumber.SEVERITY_NUMBER_INFO2;
            }
            case INFO3: {
                return SeverityNumber.SEVERITY_NUMBER_INFO3;
            }
            case INFO4: {
                return SeverityNumber.SEVERITY_NUMBER_INFO4;
            }
            case WARN: {
                return SeverityNumber.SEVERITY_NUMBER_WARN;
            }
            case WARN2: {
                return SeverityNumber.SEVERITY_NUMBER_WARN2;
            }
            case WARN3: {
                return SeverityNumber.SEVERITY_NUMBER_WARN3;
            }
            case WARN4: {
                return SeverityNumber.SEVERITY_NUMBER_WARN4;
            }
            case ERROR: {
                return SeverityNumber.SEVERITY_NUMBER_ERROR;
            }
            case ERROR2: {
                return SeverityNumber.SEVERITY_NUMBER_ERROR2;
            }
            case ERROR3: {
                return SeverityNumber.SEVERITY_NUMBER_ERROR3;
            }
            case ERROR4: {
                return SeverityNumber.SEVERITY_NUMBER_ERROR4;
            }
            case FATAL: {
                return SeverityNumber.SEVERITY_NUMBER_FATAL;
            }
            case FATAL2: {
                return SeverityNumber.SEVERITY_NUMBER_FATAL2;
            }
            case FATAL3: {
                return SeverityNumber.SEVERITY_NUMBER_FATAL3;
            }
            case FATAL4: {
                return SeverityNumber.SEVERITY_NUMBER_FATAL4;
            }
            case UNDEFINED_SEVERITY_NUMBER: {
                return SeverityNumber.SEVERITY_NUMBER_UNSPECIFIED;
            }
        }
        return SeverityNumber.SEVERITY_NUMBER_UNSPECIFIED;
    }

    private static int toUnsignedInt(byte by) {
        return by & 0xFF;
    }
}

