/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.exporter.internal.otlp.metrics;

import com.contrastsecurity.thirdparty.iot.exporter.internal.marshal.Marshaler;
import com.contrastsecurity.thirdparty.iot.exporter.internal.marshal.MarshalerUtil;
import com.contrastsecurity.thirdparty.iot.exporter.internal.marshal.MarshalerWithSize;
import com.contrastsecurity.thirdparty.iot.exporter.internal.marshal.ProtoEnumInfo;
import com.contrastsecurity.thirdparty.iot.exporter.internal.marshal.ProtoFieldInfo;
import com.contrastsecurity.thirdparty.iot.exporter.internal.marshal.Serializer;
import com.contrastsecurity.thirdparty.iot.exporter.internal.otlp.metrics.HistogramDataPointMarshaler;
import com.contrastsecurity.thirdparty.iot.exporter.internal.otlp.metrics.MetricsMarshalerUtil;
import com.contrastsecurity.thirdparty.iot.proto.metrics.v1.internal.Histogram;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.data.HistogramData;
import java.io.IOException;

final class HistogramMarshaler
extends MarshalerWithSize {
    private final HistogramDataPointMarshaler[] dataPoints;
    private final ProtoEnumInfo aggregationTemporality;

    static HistogramMarshaler create(HistogramData histogramData) {
        HistogramDataPointMarshaler[] histogramDataPointMarshalerArray = HistogramDataPointMarshaler.createRepeated(histogramData.getPoints());
        return new HistogramMarshaler(histogramDataPointMarshalerArray, MetricsMarshalerUtil.mapToTemporality(histogramData.getAggregationTemporality()));
    }

    private HistogramMarshaler(HistogramDataPointMarshaler[] histogramDataPointMarshalerArray, ProtoEnumInfo protoEnumInfo) {
        super(HistogramMarshaler.calculateSize(histogramDataPointMarshalerArray, protoEnumInfo));
        this.dataPoints = histogramDataPointMarshalerArray;
        this.aggregationTemporality = protoEnumInfo;
    }

    @Override
    public void writeTo(Serializer serializer) throws IOException {
        serializer.serializeRepeatedMessage(Histogram.DATA_POINTS, this.dataPoints);
        serializer.serializeEnum(Histogram.AGGREGATION_TEMPORALITY, this.aggregationTemporality);
    }

    private static int calculateSize(HistogramDataPointMarshaler[] histogramDataPointMarshalerArray, ProtoEnumInfo protoEnumInfo) {
        int n2 = 0;
        n2 += MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)Histogram.DATA_POINTS, (Marshaler[])histogramDataPointMarshalerArray);
        return n2 += MarshalerUtil.sizeEnum(Histogram.AGGREGATION_TEMPORALITY, protoEnumInfo);
    }
}

