/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.exporter.internal.otlp.metrics;

import com.contrastsecurity.thirdparty.iot.exporter.internal.marshal.Marshaler;
import com.contrastsecurity.thirdparty.iot.exporter.internal.marshal.MarshalerUtil;
import com.contrastsecurity.thirdparty.iot.exporter.internal.marshal.MarshalerWithSize;
import com.contrastsecurity.thirdparty.iot.exporter.internal.marshal.ProtoFieldInfo;
import com.contrastsecurity.thirdparty.iot.exporter.internal.marshal.Serializer;
import com.contrastsecurity.thirdparty.iot.exporter.internal.otlp.KeyValueMarshaler;
import com.contrastsecurity.thirdparty.iot.exporter.internal.otlp.metrics.ExemplarMarshaler;
import com.contrastsecurity.thirdparty.iot.proto.metrics.v1.internal.NumberDataPoint;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.data.DoublePointData;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.data.LongPointData;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.data.PointData;
import java.io.IOException;
import java.util.Collection;

final class NumberDataPointMarshaler
extends MarshalerWithSize {
    private final long startTimeUnixNano;
    private final long timeUnixNano;
    private final PointData value;
    private final ProtoFieldInfo valueField;
    private final ExemplarMarshaler[] exemplars;
    private final KeyValueMarshaler[] attributes;

    static NumberDataPointMarshaler[] createRepeated(Collection<? extends PointData> collection) {
        int n2 = collection.size();
        NumberDataPointMarshaler[] numberDataPointMarshalerArray = new NumberDataPointMarshaler[n2];
        int n3 = 0;
        for (PointData pointData : collection) {
            numberDataPointMarshalerArray[n3++] = NumberDataPointMarshaler.create(pointData);
        }
        return numberDataPointMarshalerArray;
    }

    static NumberDataPointMarshaler create(PointData pointData) {
        ProtoFieldInfo protoFieldInfo;
        ExemplarMarshaler[] exemplarMarshalerArray = ExemplarMarshaler.createRepeated(pointData.getExemplars());
        KeyValueMarshaler[] keyValueMarshalerArray = KeyValueMarshaler.createRepeated(pointData.getAttributes());
        if (pointData instanceof LongPointData) {
            protoFieldInfo = NumberDataPoint.AS_INT;
        } else {
            assert (pointData instanceof DoublePointData);
            protoFieldInfo = NumberDataPoint.AS_DOUBLE;
        }
        return new NumberDataPointMarshaler(pointData.getStartEpochNanos(), pointData.getEpochNanos(), pointData, protoFieldInfo, exemplarMarshalerArray, keyValueMarshalerArray);
    }

    private NumberDataPointMarshaler(long l2, long l3, PointData pointData, ProtoFieldInfo protoFieldInfo, ExemplarMarshaler[] exemplarMarshalerArray, KeyValueMarshaler[] keyValueMarshalerArray) {
        super(NumberDataPointMarshaler.calculateSize(l2, l3, protoFieldInfo, pointData, exemplarMarshalerArray, keyValueMarshalerArray));
        this.startTimeUnixNano = l2;
        this.timeUnixNano = l3;
        this.value = pointData;
        this.valueField = protoFieldInfo;
        this.exemplars = exemplarMarshalerArray;
        this.attributes = keyValueMarshalerArray;
    }

    @Override
    public void writeTo(Serializer serializer) throws IOException {
        serializer.serializeFixed64(NumberDataPoint.START_TIME_UNIX_NANO, this.startTimeUnixNano);
        serializer.serializeFixed64(NumberDataPoint.TIME_UNIX_NANO, this.timeUnixNano);
        if (this.valueField == NumberDataPoint.AS_INT) {
            serializer.serializeFixed64Optional(this.valueField, ((LongPointData)this.value).getValue());
        } else {
            serializer.serializeDoubleOptional(this.valueField, ((DoublePointData)this.value).getValue());
        }
        serializer.serializeRepeatedMessage(NumberDataPoint.EXEMPLARS, this.exemplars);
        serializer.serializeRepeatedMessage(NumberDataPoint.ATTRIBUTES, this.attributes);
    }

    private static int calculateSize(long l2, long l3, ProtoFieldInfo protoFieldInfo, PointData pointData, ExemplarMarshaler[] exemplarMarshalerArray, KeyValueMarshaler[] keyValueMarshalerArray) {
        int n2 = 0;
        n2 += MarshalerUtil.sizeFixed64(NumberDataPoint.START_TIME_UNIX_NANO, l2);
        n2 += MarshalerUtil.sizeFixed64(NumberDataPoint.TIME_UNIX_NANO, l3);
        n2 = protoFieldInfo == NumberDataPoint.AS_INT ? (n2 += MarshalerUtil.sizeFixed64Optional(protoFieldInfo, ((LongPointData)pointData).getValue())) : (n2 += MarshalerUtil.sizeDoubleOptional(protoFieldInfo, ((DoublePointData)pointData).getValue()));
        n2 += MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)NumberDataPoint.EXEMPLARS, (Marshaler[])exemplarMarshalerArray);
        return n2 += MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)NumberDataPoint.ATTRIBUTES, (Marshaler[])keyValueMarshalerArray);
    }
}

