/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.exporter.internal.otlp.metrics;

import com.contrastsecurity.thirdparty.iot.exporter.internal.marshal.Marshaler;
import com.contrastsecurity.thirdparty.iot.exporter.internal.marshal.MarshalerUtil;
import com.contrastsecurity.thirdparty.iot.exporter.internal.marshal.MarshalerWithSize;
import com.contrastsecurity.thirdparty.iot.exporter.internal.marshal.ProtoFieldInfo;
import com.contrastsecurity.thirdparty.iot.exporter.internal.marshal.Serializer;
import com.contrastsecurity.thirdparty.iot.exporter.internal.otlp.InstrumentationScopeMarshaler;
import com.contrastsecurity.thirdparty.iot.exporter.internal.otlp.ResourceMarshaler;
import com.contrastsecurity.thirdparty.iot.exporter.internal.otlp.metrics.InstrumentationScopeMetricsMarshaler;
import com.contrastsecurity.thirdparty.iot.exporter.internal.otlp.metrics.MetricMarshaler;
import com.contrastsecurity.thirdparty.iot.proto.metrics.v1.internal.ResourceMetrics;
import com.contrastsecurity.thirdparty.iot.sdk.common.InstrumentationScopeInfo;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.data.MetricData;
import com.contrastsecurity.thirdparty.iot.sdk.resources.Resource;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public final class ResourceMetricsMarshaler
extends MarshalerWithSize {
    private final ResourceMarshaler resourceMarshaler;
    private final byte[] schemaUrl;
    private final InstrumentationScopeMetricsMarshaler[] instrumentationScopeMetricsMarshalers;

    public static ResourceMetricsMarshaler[] create(Collection<MetricData> collection) {
        Map<Resource, Map<InstrumentationScopeInfo, List<Marshaler>>> map = ResourceMetricsMarshaler.groupByResourceAndScope(collection);
        ResourceMetricsMarshaler[] resourceMetricsMarshalerArray = new ResourceMetricsMarshaler[map.size()];
        int n2 = 0;
        for (Map.Entry<Resource, Map<InstrumentationScopeInfo, List<Marshaler>>> entry : map.entrySet()) {
            InstrumentationScopeMetricsMarshaler[] instrumentationScopeMetricsMarshalerArray = new InstrumentationScopeMetricsMarshaler[entry.getValue().size()];
            int n3 = 0;
            for (Map.Entry<InstrumentationScopeInfo, List<Marshaler>> entry2 : entry.getValue().entrySet()) {
                instrumentationScopeMetricsMarshalerArray[n3++] = new InstrumentationScopeMetricsMarshaler(InstrumentationScopeMarshaler.create(entry2.getKey()), MarshalerUtil.toBytes(entry2.getKey().getSchemaUrl()), entry2.getValue());
            }
            resourceMetricsMarshalerArray[n2++] = new ResourceMetricsMarshaler(ResourceMarshaler.create(entry.getKey()), MarshalerUtil.toBytes(entry.getKey().getSchemaUrl()), instrumentationScopeMetricsMarshalerArray);
        }
        return resourceMetricsMarshalerArray;
    }

    ResourceMetricsMarshaler(ResourceMarshaler resourceMarshaler, byte[] byArray, InstrumentationScopeMetricsMarshaler[] instrumentationScopeMetricsMarshalerArray) {
        super(ResourceMetricsMarshaler.calculateSize(resourceMarshaler, byArray, instrumentationScopeMetricsMarshalerArray));
        this.resourceMarshaler = resourceMarshaler;
        this.schemaUrl = byArray;
        this.instrumentationScopeMetricsMarshalers = instrumentationScopeMetricsMarshalerArray;
    }

    @Override
    public void writeTo(Serializer serializer) throws IOException {
        serializer.serializeMessage(ResourceMetrics.RESOURCE, this.resourceMarshaler);
        serializer.serializeRepeatedMessage(ResourceMetrics.SCOPE_METRICS, this.instrumentationScopeMetricsMarshalers);
        serializer.serializeString(ResourceMetrics.SCHEMA_URL, this.schemaUrl);
    }

    private static int calculateSize(ResourceMarshaler resourceMarshaler, byte[] byArray, InstrumentationScopeMetricsMarshaler[] instrumentationScopeMetricsMarshalerArray) {
        int n2 = 0;
        n2 += MarshalerUtil.sizeMessage(ResourceMetrics.RESOURCE, resourceMarshaler);
        n2 += MarshalerUtil.sizeBytes(ResourceMetrics.SCHEMA_URL, byArray);
        return n2 += MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)ResourceMetrics.SCOPE_METRICS, (Marshaler[])instrumentationScopeMetricsMarshalerArray);
    }

    private static Map<Resource, Map<InstrumentationScopeInfo, List<Marshaler>>> groupByResourceAndScope(Collection<MetricData> collection) {
        return MarshalerUtil.groupByResourceAndScope(collection, MetricData::getResource, MetricData::getInstrumentationScopeInfo, MetricMarshaler::create);
    }
}

