/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.exporter.internal.otlp.metrics;

import com.contrastsecurity.thirdparty.iot.exporter.internal.marshal.Marshaler;
import com.contrastsecurity.thirdparty.iot.exporter.internal.marshal.MarshalerUtil;
import com.contrastsecurity.thirdparty.iot.exporter.internal.marshal.MarshalerWithSize;
import com.contrastsecurity.thirdparty.iot.exporter.internal.marshal.ProtoEnumInfo;
import com.contrastsecurity.thirdparty.iot.exporter.internal.marshal.ProtoFieldInfo;
import com.contrastsecurity.thirdparty.iot.exporter.internal.marshal.Serializer;
import com.contrastsecurity.thirdparty.iot.exporter.internal.otlp.metrics.MetricsMarshalerUtil;
import com.contrastsecurity.thirdparty.iot.exporter.internal.otlp.metrics.NumberDataPointMarshaler;
import com.contrastsecurity.thirdparty.iot.proto.metrics.v1.internal.Sum;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.data.PointData;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.data.SumData;
import java.io.IOException;

final class SumMarshaler
extends MarshalerWithSize {
    private final NumberDataPointMarshaler[] dataPoints;
    private final ProtoEnumInfo aggregationTemporality;
    private final boolean isMonotonic;

    static SumMarshaler create(SumData<? extends PointData> sumData) {
        NumberDataPointMarshaler[] numberDataPointMarshalerArray = NumberDataPointMarshaler.createRepeated(sumData.getPoints());
        return new SumMarshaler(numberDataPointMarshalerArray, MetricsMarshalerUtil.mapToTemporality(sumData.getAggregationTemporality()), sumData.isMonotonic());
    }

    private SumMarshaler(NumberDataPointMarshaler[] numberDataPointMarshalerArray, ProtoEnumInfo protoEnumInfo, boolean bl2) {
        super(SumMarshaler.calculateSize(numberDataPointMarshalerArray, protoEnumInfo, bl2));
        this.dataPoints = numberDataPointMarshalerArray;
        this.aggregationTemporality = protoEnumInfo;
        this.isMonotonic = bl2;
    }

    @Override
    public void writeTo(Serializer serializer) throws IOException {
        serializer.serializeRepeatedMessage(Sum.DATA_POINTS, this.dataPoints);
        serializer.serializeEnum(Sum.AGGREGATION_TEMPORALITY, this.aggregationTemporality);
        serializer.serializeBool(Sum.IS_MONOTONIC, this.isMonotonic);
    }

    private static int calculateSize(NumberDataPointMarshaler[] numberDataPointMarshalerArray, ProtoEnumInfo protoEnumInfo, boolean bl2) {
        int n2 = 0;
        n2 += MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)Sum.DATA_POINTS, (Marshaler[])numberDataPointMarshalerArray);
        n2 += MarshalerUtil.sizeEnum(Sum.AGGREGATION_TEMPORALITY, protoEnumInfo);
        return n2 += MarshalerUtil.sizeBool(Sum.IS_MONOTONIC, bl2);
    }
}

