/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.exporter.otlp.http.logs;

import com.contrastsecurity.thirdparty.iot.exporter.internal.http.HttpExporter;
import com.contrastsecurity.thirdparty.iot.exporter.internal.http.HttpExporterBuilder;
import com.contrastsecurity.thirdparty.iot.exporter.internal.otlp.logs.LogsRequestMarshaler;
import com.contrastsecurity.thirdparty.iot.exporter.otlp.http.logs.OtlpHttpLogRecordExporterBuilder;
import com.contrastsecurity.thirdparty.iot.sdk.common.CompletableResultCode;
import com.contrastsecurity.thirdparty.iot.sdk.logs.data.LogRecordData;
import com.contrastsecurity.thirdparty.iot.sdk.logs.export.LogRecordExporter;
import java.util.Collection;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class OtlpHttpLogRecordExporter
implements LogRecordExporter {
    private final HttpExporterBuilder<LogsRequestMarshaler> builder;
    private final HttpExporter<LogsRequestMarshaler> delegate;

    OtlpHttpLogRecordExporter(HttpExporterBuilder<LogsRequestMarshaler> httpExporterBuilder, HttpExporter<LogsRequestMarshaler> httpExporter) {
        this.builder = httpExporterBuilder;
        this.delegate = httpExporter;
    }

    public static OtlpHttpLogRecordExporter getDefault() {
        return OtlpHttpLogRecordExporter.builder().build();
    }

    public static OtlpHttpLogRecordExporterBuilder builder() {
        return new OtlpHttpLogRecordExporterBuilder();
    }

    public OtlpHttpLogRecordExporterBuilder toBuilder() {
        return new OtlpHttpLogRecordExporterBuilder(this.builder.copy());
    }

    @Override
    public CompletableResultCode export(Collection<LogRecordData> collection) {
        LogsRequestMarshaler logsRequestMarshaler = LogsRequestMarshaler.create(collection);
        return this.delegate.export(logsRequestMarshaler, collection.size());
    }

    @Override
    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public CompletableResultCode shutdown() {
        return this.delegate.shutdown();
    }

    public String toString() {
        return "OtlpHttpLogRecordExporter{" + this.builder.toString(false) + "}";
    }
}

