/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.exporter.otlp.metrics;

import com.contrastsecurity.thirdparty.iot.api.internal.Utils;
import com.contrastsecurity.thirdparty.iot.api.metrics.MeterProvider;
import com.contrastsecurity.thirdparty.iot.exporter.internal.grpc.GrpcExporterBuilder;
import com.contrastsecurity.thirdparty.iot.exporter.internal.otlp.metrics.MetricsRequestMarshaler;
import com.contrastsecurity.thirdparty.iot.exporter.otlp.internal.OtlpUserAgent;
import com.contrastsecurity.thirdparty.iot.exporter.otlp.metrics.MarshalerMetricsServiceGrpc;
import com.contrastsecurity.thirdparty.iot.exporter.otlp.metrics.OtlpGrpcMetricExporter;
import com.contrastsecurity.thirdparty.iot.sdk.common.export.RetryPolicy;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.export.AggregationTemporalitySelector;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.export.DefaultAggregationSelector;
import io.grpc.ManagedChannel;
import java.net.URI;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;

public final class OtlpGrpcMetricExporterBuilder {
    private static final String GRPC_SERVICE_NAME = "com.contrastsecurity.thirdparty.otp.collector.metrics.v1.MetricsService";
    static final String GRPC_ENDPOINT_PATH = "/opentelemetry.proto.collector.metrics.v1.MetricsService/Export";
    private static final String DEFAULT_ENDPOINT_URL = "http://localhost:4317";
    private static final URI DEFAULT_ENDPOINT = URI.create("http://localhost:4317");
    private static final long DEFAULT_TIMEOUT_SECS = 10L;
    private static final AggregationTemporalitySelector DEFAULT_AGGREGATION_TEMPORALITY_SELECTOR = AggregationTemporalitySelector.alwaysCumulative();
    final GrpcExporterBuilder<MetricsRequestMarshaler> delegate;
    private AggregationTemporalitySelector aggregationTemporalitySelector = DEFAULT_AGGREGATION_TEMPORALITY_SELECTOR;
    private DefaultAggregationSelector defaultAggregationSelector = DefaultAggregationSelector.getDefault();

    OtlpGrpcMetricExporterBuilder(GrpcExporterBuilder<MetricsRequestMarshaler> grpcExporterBuilder) {
        this.delegate = grpcExporterBuilder;
        grpcExporterBuilder.setMeterProvider(MeterProvider.noop());
        OtlpUserAgent.addUserAgentHeader(grpcExporterBuilder::addHeader);
    }

    OtlpGrpcMetricExporterBuilder() {
        this(new GrpcExporterBuilder<MetricsRequestMarshaler>("otlp", "metric", 10L, DEFAULT_ENDPOINT, () -> MarshalerMetricsServiceGrpc::newFutureStub, GRPC_ENDPOINT_PATH));
    }

    @Deprecated
    public OtlpGrpcMetricExporterBuilder setChannel(ManagedChannel managedChannel) {
        this.delegate.setChannel(managedChannel);
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setTimeout(long l2, TimeUnit timeUnit) {
        Objects.requireNonNull(timeUnit, "unit");
        Utils.checkArgument(l2 >= 0L, "timeout must be non-negative");
        this.delegate.setTimeout(l2, timeUnit);
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setTimeout(Duration duration) {
        Objects.requireNonNull(duration, "timeout");
        this.delegate.setTimeout(duration);
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setEndpoint(String string) {
        Objects.requireNonNull(string, "endpoint");
        this.delegate.setEndpoint(string);
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setCompression(String string) {
        Objects.requireNonNull(string, "compressionMethod");
        Utils.checkArgument(string.equals("gzip") || string.equals("none"), "Unsupported compression method. Supported compression methods include: gzip, none.");
        this.delegate.setCompression(string);
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setTrustedCertificates(byte[] byArray) {
        this.delegate.setTrustManagerFromCerts(byArray);
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setClientTls(byte[] byArray, byte[] byArray2) {
        this.delegate.setKeyManagerFromCerts(byArray, byArray2);
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setSslContext(SSLContext sSLContext, X509TrustManager x509TrustManager) {
        this.delegate.setSslContext(sSLContext, x509TrustManager);
        return this;
    }

    public OtlpGrpcMetricExporterBuilder addHeader(String string, String string2) {
        this.delegate.addHeader(string, string2);
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setAggregationTemporalitySelector(AggregationTemporalitySelector aggregationTemporalitySelector) {
        Objects.requireNonNull(aggregationTemporalitySelector, "aggregationTemporalitySelector");
        this.aggregationTemporalitySelector = aggregationTemporalitySelector;
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setDefaultAggregationSelector(DefaultAggregationSelector defaultAggregationSelector) {
        Objects.requireNonNull(defaultAggregationSelector, "defaultAggregationSelector");
        this.defaultAggregationSelector = defaultAggregationSelector;
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setRetryPolicy(RetryPolicy retryPolicy) {
        Objects.requireNonNull(retryPolicy, "retryPolicy");
        this.delegate.setRetryPolicy(retryPolicy);
        return this;
    }

    public OtlpGrpcMetricExporter build() {
        return new OtlpGrpcMetricExporter(this.delegate, this.delegate.build(), this.aggregationTemporalitySelector, this.defaultAggregationSelector);
    }
}

