/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.sdk;

import com.contrastsecurity.agent.logging.log4j2.e;
import com.contrastsecurity.thirdparty.iot.api.OpenTelemetry;
import com.contrastsecurity.thirdparty.iot.api.logs.LoggerBuilder;
import com.contrastsecurity.thirdparty.iot.api.logs.LoggerProvider;
import com.contrastsecurity.thirdparty.iot.api.metrics.MeterBuilder;
import com.contrastsecurity.thirdparty.iot.api.metrics.MeterProvider;
import com.contrastsecurity.thirdparty.iot.api.trace.Tracer;
import com.contrastsecurity.thirdparty.iot.api.trace.TracerBuilder;
import com.contrastsecurity.thirdparty.iot.api.trace.TracerProvider;
import com.contrastsecurity.thirdparty.iot.context.propagation.ContextPropagators;
import com.contrastsecurity.thirdparty.iot.sdk.OpenTelemetrySdkBuilder;
import com.contrastsecurity.thirdparty.iot.sdk.common.CompletableResultCode;
import com.contrastsecurity.thirdparty.iot.sdk.logs.SdkLoggerProvider;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.SdkMeterProvider;
import com.contrastsecurity.thirdparty.iot.sdk.trace.SdkTracerProvider;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class OpenTelemetrySdk
implements OpenTelemetry,
Closeable {
    private static final e LOGGER = e.a(OpenTelemetrySdk.class.getName());
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);
    private final ObfuscatedTracerProvider tracerProvider;
    private final ObfuscatedMeterProvider meterProvider;
    private final ObfuscatedLoggerProvider loggerProvider;
    private final ContextPropagators propagators;

    OpenTelemetrySdk(SdkTracerProvider sdkTracerProvider, SdkMeterProvider sdkMeterProvider, SdkLoggerProvider sdkLoggerProvider, ContextPropagators contextPropagators) {
        this.tracerProvider = new ObfuscatedTracerProvider(sdkTracerProvider);
        this.meterProvider = new ObfuscatedMeterProvider(sdkMeterProvider);
        this.loggerProvider = new ObfuscatedLoggerProvider(sdkLoggerProvider);
        this.propagators = contextPropagators;
    }

    public static OpenTelemetrySdkBuilder builder() {
        return new OpenTelemetrySdkBuilder();
    }

    @Override
    public TracerProvider getTracerProvider() {
        return this.tracerProvider;
    }

    public SdkTracerProvider getSdkTracerProvider() {
        return this.tracerProvider.unobfuscate();
    }

    @Override
    public MeterProvider getMeterProvider() {
        return this.meterProvider;
    }

    public SdkMeterProvider getSdkMeterProvider() {
        return this.meterProvider.unobfuscate();
    }

    @Override
    public LoggerProvider getLogsBridge() {
        return this.loggerProvider;
    }

    public SdkLoggerProvider getSdkLoggerProvider() {
        return this.loggerProvider.unobfuscate();
    }

    @Override
    public ContextPropagators getPropagators() {
        return this.propagators;
    }

    public CompletableResultCode shutdown() {
        if (!this.isShutdown.compareAndSet(false, true)) {
            LOGGER.d("Multiple shutdown calls");
            return CompletableResultCode.ofSuccess();
        }
        ArrayList<CompletableResultCode> arrayList = new ArrayList<CompletableResultCode>();
        arrayList.add(this.tracerProvider.unobfuscate().shutdown());
        arrayList.add(this.meterProvider.unobfuscate().shutdown());
        arrayList.add(this.loggerProvider.unobfuscate().shutdown());
        return CompletableResultCode.ofAll(arrayList);
    }

    @Override
    public void close() {
        this.shutdown().join(10L, TimeUnit.SECONDS);
    }

    public String toString() {
        return "OpenTelemetrySdk{tracerProvider=" + this.tracerProvider.unobfuscate() + ", meterProvider=" + this.meterProvider.unobfuscate() + ", loggerProvider=" + this.loggerProvider.unobfuscate() + ", propagators=" + this.propagators + "}";
    }

    @ThreadSafe
    static class ObfuscatedTracerProvider
    implements TracerProvider {
        private final SdkTracerProvider delegate;

        ObfuscatedTracerProvider(SdkTracerProvider sdkTracerProvider) {
            this.delegate = sdkTracerProvider;
        }

        @Override
        public Tracer get(String string) {
            return this.delegate.get(string);
        }

        @Override
        public Tracer get(String string, String string2) {
            return this.delegate.get(string, string2);
        }

        @Override
        public TracerBuilder tracerBuilder(String string) {
            return this.delegate.tracerBuilder(string);
        }

        public SdkTracerProvider unobfuscate() {
            return this.delegate;
        }
    }

    @ThreadSafe
    static class ObfuscatedMeterProvider
    implements MeterProvider {
        private final SdkMeterProvider delegate;

        ObfuscatedMeterProvider(SdkMeterProvider sdkMeterProvider) {
            this.delegate = sdkMeterProvider;
        }

        @Override
        public MeterBuilder meterBuilder(String string) {
            return this.delegate.meterBuilder(string);
        }

        public SdkMeterProvider unobfuscate() {
            return this.delegate;
        }
    }

    @ThreadSafe
    static class ObfuscatedLoggerProvider
    implements LoggerProvider {
        private final SdkLoggerProvider delegate;

        ObfuscatedLoggerProvider(SdkLoggerProvider sdkLoggerProvider) {
            this.delegate = sdkLoggerProvider;
        }

        @Override
        public LoggerBuilder loggerBuilder(String string) {
            return this.delegate.loggerBuilder(string);
        }

        public SdkLoggerProvider unobfuscate() {
            return this.delegate;
        }
    }
}

