/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.sdk.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;

public final class CompletableResultCode {
    private static final CompletableResultCode SUCCESS = new CompletableResultCode().succeed();
    private static final CompletableResultCode FAILURE = new CompletableResultCode().fail();
    @Nullable
    private Boolean succeeded = null;
    private final List<Runnable> completionActions = new ArrayList<Runnable>();
    private final Object lock = new Object();

    public static CompletableResultCode ofSuccess() {
        return SUCCESS;
    }

    public static CompletableResultCode ofFailure() {
        return FAILURE;
    }

    public static CompletableResultCode ofAll(Collection<CompletableResultCode> collection) {
        if (collection.isEmpty()) {
            return CompletableResultCode.ofSuccess();
        }
        CompletableResultCode completableResultCode = new CompletableResultCode();
        AtomicInteger atomicInteger = new AtomicInteger(collection.size());
        AtomicBoolean atomicBoolean = new AtomicBoolean();
        for (CompletableResultCode completableResultCode2 : collection) {
            completableResultCode2.whenComplete(() -> {
                if (!completableResultCode2.isSuccess()) {
                    atomicBoolean.set(true);
                }
                if (atomicInteger.decrementAndGet() == 0) {
                    if (atomicBoolean.get()) {
                        completableResultCode.fail();
                    } else {
                        completableResultCode.succeed();
                    }
                }
            });
        }
        return completableResultCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableResultCode succeed() {
        Object object = this.lock;
        synchronized (object) {
            if (this.succeeded == null) {
                this.succeeded = true;
                for (Runnable runnable : this.completionActions) {
                    runnable.run();
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableResultCode fail() {
        Object object = this.lock;
        synchronized (object) {
            if (this.succeeded == null) {
                this.succeeded = false;
                for (Runnable runnable : this.completionActions) {
                    runnable.run();
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSuccess() {
        Object object = this.lock;
        synchronized (object) {
            return this.succeeded != null && this.succeeded != false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableResultCode whenComplete(Runnable runnable) {
        boolean bl2 = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.succeeded != null) {
                bl2 = true;
            } else {
                this.completionActions.add(runnable);
            }
        }
        if (bl2) {
            runnable.run();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDone() {
        Object object = this.lock;
        synchronized (object) {
            return this.succeeded != null;
        }
    }

    public CompletableResultCode join(long l2, TimeUnit timeUnit) {
        if (this.isDone()) {
            return this;
        }
        CountDownLatch countDownLatch = new CountDownLatch(1);
        this.whenComplete(countDownLatch::countDown);
        try {
            if (!countDownLatch.await(l2, timeUnit)) {
                return this;
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        return this;
    }
}

