/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.sdk.internal;

import com.contrastsecurity.agent.commons.Throwables;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public final class DaemonThreadFactory
implements ThreadFactory {
    private final String namePrefix;
    private final AtomicInteger counter = new AtomicInteger();
    private final ThreadFactory delegate = Executors.defaultThreadFactory();

    public DaemonThreadFactory(String string) {
        this.namePrefix = string;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = this.delegate.newThread(runnable);
        try {
            thread.setDaemon(true);
            thread.setName(this.namePrefix + "-" + this.counter.incrementAndGet());
        }
        catch (SecurityException securityException) {
            Throwables.throwIfCritical(securityException);
            SecurityException securityException2 = securityException;
        }
        return thread;
    }
}

