/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.sdk.logs;

import com.contrastsecurity.thirdparty.iot.sdk.common.Clock;
import com.contrastsecurity.thirdparty.iot.sdk.common.CompletableResultCode;
import com.contrastsecurity.thirdparty.iot.sdk.logs.LogLimits;
import com.contrastsecurity.thirdparty.iot.sdk.logs.LogRecordProcessor;
import com.contrastsecurity.thirdparty.iot.sdk.resources.Resource;
import java.util.function.Supplier;
import javax.annotation.Nullable;

final class LoggerSharedState {
    private final Object lock = new Object();
    private final Resource resource;
    private final Supplier<LogLimits> logLimitsSupplier;
    private final LogRecordProcessor logRecordProcessor;
    private final Clock clock;
    @Nullable
    private volatile CompletableResultCode shutdownResult = null;

    LoggerSharedState(Resource resource, Supplier<LogLimits> supplier, LogRecordProcessor logRecordProcessor, Clock clock) {
        this.resource = resource;
        this.logLimitsSupplier = supplier;
        this.logRecordProcessor = logRecordProcessor;
        this.clock = clock;
    }

    Resource getResource() {
        return this.resource;
    }

    LogLimits getLogLimits() {
        return this.logLimitsSupplier.get();
    }

    LogRecordProcessor getLogRecordProcessor() {
        return this.logRecordProcessor;
    }

    Clock getClock() {
        return this.clock;
    }

    boolean hasBeenShutdown() {
        return this.shutdownResult != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompletableResultCode shutdown() {
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdownResult != null) {
                return this.shutdownResult;
            }
            this.shutdownResult = this.logRecordProcessor.shutdown();
            return this.shutdownResult;
        }
    }
}

