/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.sdk.logs;

import com.contrastsecurity.thirdparty.iot.sdk.common.Clock;
import com.contrastsecurity.thirdparty.iot.sdk.logs.LogLimits;
import com.contrastsecurity.thirdparty.iot.sdk.logs.LogRecordProcessor;
import com.contrastsecurity.thirdparty.iot.sdk.logs.SdkLoggerProvider;
import com.contrastsecurity.thirdparty.iot.sdk.resources.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public final class SdkLoggerProviderBuilder {
    private final List<LogRecordProcessor> logRecordProcessors = new ArrayList<LogRecordProcessor>();
    private Resource resource = Resource.getDefault();
    private Supplier<LogLimits> logLimitsSupplier = LogLimits::getDefault;
    private Clock clock = Clock.getDefault();

    SdkLoggerProviderBuilder() {
    }

    public SdkLoggerProviderBuilder setResource(Resource resource) {
        Objects.requireNonNull(resource, "resource");
        this.resource = resource;
        return this;
    }

    public SdkLoggerProviderBuilder addResource(Resource resource) {
        Objects.requireNonNull(resource, "resource");
        this.resource = this.resource.merge(resource);
        return this;
    }

    public SdkLoggerProviderBuilder setLogLimits(Supplier<LogLimits> supplier) {
        Objects.requireNonNull(supplier, "logLimitsSupplier");
        this.logLimitsSupplier = supplier;
        return this;
    }

    public SdkLoggerProviderBuilder addLogRecordProcessor(LogRecordProcessor logRecordProcessor) {
        Objects.requireNonNull(logRecordProcessor, "processor");
        this.logRecordProcessors.add(logRecordProcessor);
        return this;
    }

    public SdkLoggerProviderBuilder setClock(Clock clock) {
        Objects.requireNonNull(clock, "clock");
        this.clock = clock;
        return this;
    }

    public SdkLoggerProvider build() {
        return new SdkLoggerProvider(this.resource, this.logLimitsSupplier, this.logRecordProcessors, this.clock);
    }
}

