/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.sdk.metrics;

import com.contrastsecurity.agent.logging.log4j2.e;
import com.contrastsecurity.thirdparty.iot.api.common.Attributes;
import com.contrastsecurity.thirdparty.iot.api.metrics.DoubleHistogram;
import com.contrastsecurity.thirdparty.iot.api.metrics.LongHistogramBuilder;
import com.contrastsecurity.thirdparty.iot.context.Context;
import com.contrastsecurity.thirdparty.iot.extension.incubator.metrics.DoubleHistogramAdviceConfigurer;
import com.contrastsecurity.thirdparty.iot.extension.incubator.metrics.ExtendedDoubleHistogramBuilder;
import com.contrastsecurity.thirdparty.iot.sdk.internal.ThrottlingLogger;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.AbstractInstrument;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.AbstractInstrumentBuilder;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.InstrumentType;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.InstrumentValueType;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.SdkLongHistogram;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.descriptor.Advice;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.state.MeterProviderSharedState;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.state.MeterSharedState;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.state.WriteableMetricStorage;
import java.util.List;
import java.util.function.Consumer;

final class SdkDoubleHistogram
extends AbstractInstrument
implements DoubleHistogram {
    private static final e logger = e.a(SdkDoubleHistogram.class.getName());
    private final ThrottlingLogger throttlingLogger = new ThrottlingLogger(logger);
    private final WriteableMetricStorage storage;

    private SdkDoubleHistogram(InstrumentDescriptor instrumentDescriptor, WriteableMetricStorage writeableMetricStorage) {
        super(instrumentDescriptor);
        this.storage = writeableMetricStorage;
    }

    @Override
    public void record(double d2, Attributes attributes, Context context) {
        if (d2 < 0.0) {
            this.throttlingLogger.log(e.a.c, "Histograms can only record non-negative values. Instrument " + this.getDescriptor().getName() + " has recorded a negative value.");
            return;
        }
        this.storage.recordDouble(d2, attributes, context);
    }

    @Override
    public void record(double d2, Attributes attributes) {
        this.record(d2, attributes, Context.current());
    }

    @Override
    public void record(double d2) {
        this.record(d2, Attributes.empty());
    }

    static final class SdkDoubleHistogramBuilder
    extends AbstractInstrumentBuilder<SdkDoubleHistogramBuilder>
    implements DoubleHistogramAdviceConfigurer,
    ExtendedDoubleHistogramBuilder {
        SdkDoubleHistogramBuilder(MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, String string) {
            super(meterProviderSharedState, meterSharedState, InstrumentType.HISTOGRAM, InstrumentValueType.DOUBLE, string, "", "");
        }

        @Override
        protected SdkDoubleHistogramBuilder getThis() {
            return this;
        }

        @Override
        public SdkDoubleHistogramBuilder setAdvice(Consumer<DoubleHistogramAdviceConfigurer> consumer) {
            consumer.accept(this);
            return this;
        }

        @Override
        public SdkDoubleHistogram build() {
            return this.buildSynchronousInstrument((instrumentDescriptor, writeableMetricStorage) -> new SdkDoubleHistogram((InstrumentDescriptor)instrumentDescriptor, (WriteableMetricStorage)writeableMetricStorage));
        }

        @Override
        public LongHistogramBuilder ofLongs() {
            return this.swapBuilder(SdkLongHistogram.SdkLongHistogramBuilder::new);
        }

        @Override
        public DoubleHistogramAdviceConfigurer setExplicitBucketBoundaries(List<Double> list) {
            this.setAdvice(Advice.create(list));
            return this;
        }
    }
}

