/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.sdk.metrics;

import com.contrastsecurity.thirdparty.iot.sdk.common.Clock;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.InstrumentSelector;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.SdkMeterProvider;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.View;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.export.MetricReader;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.debug.SourceInfo;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.exemplar.ExemplarFilter;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.export.CardinalityLimitSelector;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.view.RegisteredView;
import com.contrastsecurity.thirdparty.iot.sdk.resources.Resource;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;

public final class SdkMeterProviderBuilder {
    private static final ExemplarFilter DEFAULT_EXEMPLAR_FILTER = ExemplarFilter.traceBased();
    private Clock clock = Clock.getDefault();
    private Resource resource = Resource.getDefault();
    private final IdentityHashMap<MetricReader, CardinalityLimitSelector> metricReaders = new IdentityHashMap();
    private final List<RegisteredView> registeredViews = new ArrayList<RegisteredView>();
    private ExemplarFilter exemplarFilter = DEFAULT_EXEMPLAR_FILTER;

    SdkMeterProviderBuilder() {
    }

    public SdkMeterProviderBuilder setClock(Clock clock) {
        Objects.requireNonNull(clock, "clock");
        this.clock = clock;
        return this;
    }

    public SdkMeterProviderBuilder setResource(Resource resource) {
        Objects.requireNonNull(resource, "resource");
        this.resource = resource;
        return this;
    }

    public SdkMeterProviderBuilder addResource(Resource resource) {
        Objects.requireNonNull(resource, "resource");
        this.resource = this.resource.merge(resource);
        return this;
    }

    SdkMeterProviderBuilder setExemplarFilter(ExemplarFilter exemplarFilter) {
        this.exemplarFilter = exemplarFilter;
        return this;
    }

    public SdkMeterProviderBuilder registerView(InstrumentSelector instrumentSelector, View view) {
        Objects.requireNonNull(instrumentSelector, "selector");
        Objects.requireNonNull(view, "view");
        this.registeredViews.add(RegisteredView.create(instrumentSelector, view, view.getAttributesProcessor(), view.getCardinalityLimit(), SourceInfo.fromCurrentStack()));
        return this;
    }

    public SdkMeterProviderBuilder registerMetricReader(MetricReader metricReader) {
        this.metricReaders.put(metricReader, CardinalityLimitSelector.defaultCardinalityLimitSelector());
        return this;
    }

    SdkMeterProviderBuilder registerMetricReader(MetricReader metricReader, CardinalityLimitSelector cardinalityLimitSelector) {
        this.metricReaders.put(metricReader, cardinalityLimitSelector);
        return this;
    }

    public SdkMeterProvider build() {
        return new SdkMeterProvider(this.registeredViews, this.metricReaders, this.clock, this.resource, this.exemplarFilter);
    }
}

