/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.sdk.metrics.export;

import com.contrastsecurity.thirdparty.iot.api.internal.Utils;
import com.contrastsecurity.thirdparty.iot.sdk.internal.DaemonThreadFactory;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.export.MetricExporter;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.export.PeriodicMetricReader;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public final class PeriodicMetricReaderBuilder {
    static final long DEFAULT_SCHEDULE_DELAY_MINUTES = 1L;
    private final MetricExporter metricExporter;
    private long intervalNanos = TimeUnit.MINUTES.toNanos(1L);
    @Nullable
    private ScheduledExecutorService executor;

    PeriodicMetricReaderBuilder(MetricExporter metricExporter) {
        this.metricExporter = metricExporter;
    }

    public PeriodicMetricReaderBuilder setInterval(long l2, TimeUnit timeUnit) {
        Objects.requireNonNull(timeUnit, "unit");
        Utils.checkArgument(l2 > 0L, "interval must be positive");
        this.intervalNanos = timeUnit.toNanos(l2);
        return this;
    }

    public PeriodicMetricReaderBuilder setInterval(Duration duration) {
        Objects.requireNonNull(duration, "interval");
        return this.setInterval(duration.toNanos(), TimeUnit.NANOSECONDS);
    }

    public PeriodicMetricReaderBuilder setExecutor(ScheduledExecutorService scheduledExecutorService) {
        Objects.requireNonNull(scheduledExecutorService, "executor");
        this.executor = scheduledExecutorService;
        return this;
    }

    public PeriodicMetricReader build() {
        ScheduledExecutorService scheduledExecutorService = this.executor;
        if (scheduledExecutorService == null) {
            scheduledExecutorService = Executors.newScheduledThreadPool(1, new DaemonThreadFactory("PeriodicMetricReader"));
        }
        return new PeriodicMetricReader(this.metricExporter, this.intervalNanos, scheduledExecutorService);
    }
}

