/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.aggregator;

import com.contrastsecurity.thirdparty.iot.api.common.Attributes;
import com.contrastsecurity.thirdparty.iot.context.Context;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.data.ExemplarData;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.data.PointData;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.exemplar.ExemplarReservoir;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class AggregatorHandle<T extends PointData, U extends ExemplarData> {
    private final ExemplarReservoir<U> exemplarReservoir;

    protected AggregatorHandle(ExemplarReservoir<U> exemplarReservoir) {
        this.exemplarReservoir = exemplarReservoir;
    }

    public final T aggregateThenMaybeReset(long l2, long l3, Attributes attributes, boolean bl2) {
        return this.doAggregateThenMaybeReset(l2, l3, attributes, this.exemplarReservoir.collectAndReset(attributes), bl2);
    }

    protected abstract T doAggregateThenMaybeReset(long var1, long var3, Attributes var5, List<U> var6, boolean var7);

    public final void recordLong(long l2, Attributes attributes, Context context) {
        this.exemplarReservoir.offerLongMeasurement(l2, attributes, context);
        this.recordLong(l2);
    }

    public final void recordLong(long l2) {
        this.doRecordLong(l2);
    }

    protected void doRecordLong(long l2) {
        throw new UnsupportedOperationException("This aggregator does not support recording long values.");
    }

    public final void recordDouble(double d2, Attributes attributes, Context context) {
        this.exemplarReservoir.offerDoubleMeasurement(d2, attributes, context);
        this.recordDouble(d2);
    }

    public final void recordDouble(double d2) {
        this.doRecordDouble(d2);
    }

    protected void doRecordDouble(double d2) {
        throw new UnsupportedOperationException("This aggregator does not support recording double values.");
    }
}

