/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.aggregator;

import com.contrastsecurity.thirdparty.iot.api.common.Attributes;
import com.contrastsecurity.thirdparty.iot.sdk.common.InstrumentationScopeInfo;
import com.contrastsecurity.thirdparty.iot.sdk.internal.PrimitiveLongList;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.data.AggregationTemporality;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.data.DoubleExemplarData;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.data.HistogramPointData;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.data.MetricData;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.aggregator.Aggregator;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.aggregator.AggregatorHandle;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.aggregator.ExplicitBucketHistogramUtils;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.data.ImmutableHistogramData;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.data.ImmutableHistogramPointData;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.data.ImmutableMetricData;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.descriptor.MetricDescriptor;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.exemplar.ExemplarReservoir;
import com.contrastsecurity.thirdparty.iot.sdk.resources.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;

public final class DoubleExplicitBucketHistogramAggregator
implements Aggregator<HistogramPointData, DoubleExemplarData> {
    private final double[] boundaries;
    private final List<Double> boundaryList;
    private final Supplier<ExemplarReservoir<DoubleExemplarData>> reservoirSupplier;

    public DoubleExplicitBucketHistogramAggregator(double[] dArray, Supplier<ExemplarReservoir<DoubleExemplarData>> supplier) {
        this.boundaries = dArray;
        ArrayList<Double> arrayList = new ArrayList<Double>(this.boundaries.length);
        for (double d2 : this.boundaries) {
            arrayList.add(d2);
        }
        this.boundaryList = Collections.unmodifiableList(arrayList);
        this.reservoirSupplier = supplier;
    }

    @Override
    public AggregatorHandle<HistogramPointData, DoubleExemplarData> createHandle() {
        return new Handle(this.boundaryList, this.boundaries, this.reservoirSupplier.get());
    }

    @Override
    public MetricData toMetricData(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, MetricDescriptor metricDescriptor, Collection<HistogramPointData> collection, AggregationTemporality aggregationTemporality) {
        return ImmutableMetricData.createDoubleHistogram(resource, instrumentationScopeInfo, metricDescriptor.getName(), metricDescriptor.getDescription(), metricDescriptor.getSourceInstrument().getUnit(), ImmutableHistogramData.create(aggregationTemporality, collection));
    }

    static final class Handle
    extends AggregatorHandle<HistogramPointData, DoubleExemplarData> {
        private final List<Double> boundaryList;
        private final double[] boundaries;
        private double sum;
        private double min;
        private double max;
        private long count;
        private final long[] counts;
        private final ReentrantLock lock = new ReentrantLock();

        Handle(List<Double> list, double[] dArray, ExemplarReservoir<DoubleExemplarData> exemplarReservoir) {
            super(exemplarReservoir);
            this.boundaryList = list;
            this.boundaries = dArray;
            this.counts = new long[this.boundaries.length + 1];
            this.sum = 0.0;
            this.min = Double.MAX_VALUE;
            this.max = -1.0;
            this.count = 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected HistogramPointData doAggregateThenMaybeReset(long l2, long l3, Attributes attributes, List<DoubleExemplarData> list, boolean bl2) {
            this.lock.lock();
            try {
                ImmutableHistogramPointData immutableHistogramPointData = ImmutableHistogramPointData.create(l2, l3, attributes, this.sum, this.count > 0L, this.min, this.count > 0L, this.max, this.boundaryList, PrimitiveLongList.wrap(Arrays.copyOf(this.counts, this.counts.length)), list);
                if (bl2) {
                    this.sum = 0.0;
                    this.min = Double.MAX_VALUE;
                    this.max = -1.0;
                    this.count = 0L;
                    Arrays.fill(this.counts, 0L);
                }
                ImmutableHistogramPointData immutableHistogramPointData2 = immutableHistogramPointData;
                return immutableHistogramPointData2;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doRecordDouble(double d2) {
            int n2 = ExplicitBucketHistogramUtils.findBucketIndex(this.boundaries, d2);
            this.lock.lock();
            try {
                this.sum += d2;
                this.min = Math.min(this.min, d2);
                this.max = Math.max(this.max, d2);
                ++this.count;
                int n3 = n2;
                this.counts[n3] = this.counts[n3] + 1L;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        protected void doRecordLong(long l2) {
            this.doRecordDouble(l2);
        }
    }
}

