/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.aggregator;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class ExplicitBucketHistogramUtils {
    public static final List<Double> DEFAULT_HISTOGRAM_BUCKET_BOUNDARIES = Collections.unmodifiableList(Arrays.asList(0.0, 5.0, 10.0, 25.0, 50.0, 75.0, 100.0, 250.0, 500.0, 750.0, 1000.0, 2500.0, 5000.0, 7500.0, 10000.0));

    private ExplicitBucketHistogramUtils() {
    }

    public static double[] createBoundaryArray(List<Double> list) {
        return ExplicitBucketHistogramUtils.validateBucketBoundaries(list.stream().mapToDouble(d2 -> d2).toArray());
    }

    public static int findBucketIndex(double[] dArray, double d2) {
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            if (!(d2 <= dArray[i2])) continue;
            return i2;
        }
        return dArray.length;
    }

    public static double[] validateBucketBoundaries(double[] dArray) {
        for (double d2 : dArray) {
            if (!Double.isNaN(d2)) continue;
            throw new IllegalArgumentException("invalid bucket boundary: NaN");
        }
        for (int i2 = 1; i2 < dArray.length; ++i2) {
            if (!(dArray[i2 - 1] >= dArray[i2])) continue;
            throw new IllegalArgumentException("Bucket boundaries must be in increasing order: " + dArray[i2 - 1] + " >= " + dArray[i2]);
        }
        if (dArray.length > 0) {
            if (dArray[0] == Double.NEGATIVE_INFINITY) {
                throw new IllegalArgumentException("invalid bucket boundary: -Inf");
            }
            if (dArray[dArray.length - 1] == Double.POSITIVE_INFINITY) {
                throw new IllegalArgumentException("invalid bucket boundary: +Inf");
            }
        }
        return dArray;
    }
}

